/*************************************************************************** */
/* sci-eco.c                                     .                           */
/*---------------------------------------------------------------------------*/
/* Ejemplo para el PUERTO SERIE                                              */
/*---------------------------------------------------------------------------*/
/* Ejemplo para la tarjeta SKYPIC                                            */
/*---------------------------------------------------------------------------*/
/*  Ejemplo de envio-recepcion de datos. Se hace eco de todo lo recibido por */
/* el puerto serie. Ademas se saca tambien por el puerto B para depurar      */
/* Se han creado funciones especificas para la lectura de datos y el envio   */
/* por el puerto serie. Esto nos permitira reutilizarlas en los demas        */
/* ejemplos                                                                  */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

#include <pic16f876a.h>
#include "sci.h"


/*********************************/
/* Programa principal            */
/*********************************/
void main(void)
{
  unsigned char c;
  
  //-- Configurar el puerto B para salida
  TRISB=0;

  //-- Configurar puerto serie
  sci_conf();

  //-- Bucle principal
  sci_cad("Haciendo eco...");
  while(1) {

    //-- Leer dato (se queda esperando hasta que llega)
    c=sci_read();

    //-- Sacar dato recibido por los leds
    PORTB=c;

    //-- Hacer eco del carácter recibido. Enviarlo de vuelta al PC
    sci_write(c);
    
  }

}

