/*************************************************************************** */
/* pulsador-led.c                                                            */
/*---------------------------------------------------------------------------*/
/* ENTRADA/SALIDA DIGITAL: PUERTO B                                          */
/*---------------------------------------------------------------------------*/
/* Ejemplo para la tarjeta SKYPIC                                            */
/*---------------------------------------------------------------------------*/
/* Ejemplo de entrada y salida. Se configura el pin RB0 como entrada y       */
/* RB1 como salida. Por RB1 (el led) se saca el valor negado de lo recibido  */
/* por RB0 (pulsador)                                                        */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

#include <pic16f876a.h>

//-- Definiciones
#define ENTRADA 1
#define SALIDA  0

#define PULSADOR  RB0    // Pin donde esta el pulsador
#define LED       RB1    // Pin del led de la Skypic


void main(void)
{
  //-- Configurar RB1 somo salida (LED) y RB0 (pulsador) como entrada
  TRISB0=ENTRADA;  //-- En realidad, los bits de TRISB estan ya a '1' por defecto
  TRISB1=SALIDA;

  while(1) {
    //-- Sacar por el led lo contrario de lo leido por el pulsador
    LED = PULSADOR^1;
  }

}

