/*****************************************************************************/
/* motores-sensor3.c      Julio-2007                                         */
/*---------------------------------------------------------------------------*/
/* Ejemplo para el skybot                                                    */
/*---------------------------------------------------------------------------*/
/*  Se lee el estado del sensor 3 y se activan los motores. Si lee blanco,   */
/*  el robot se para. Si lee negro avanza.                                   */
/*  Es un ejemplo de un comportamiento reactivo muy sencillo                 */
/*---------------------------------------------------------------------------*/
/*  Andres Prieto-Moreno <andres@ifara.com>                                  */
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Modificado por: Javier Valiente <jvaliente@ifara.com>                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>

//-- Colocacion de los sensores
#define   SENSOR1  RB0
#define   SENSOR2  RB5
#define   SENSOR3  RB6
#define   SENSOR4  RB7

//-- Valor para configurar el puerto B para trabajar con el Skybot:
//-- Bits RB0, RB5, RB6 y RB7 como entradas (sensores)
//-- Bits RB1, RB2, RB3 y RB4 como salidas
#define CONF_SKYBOT 0xE1  //-- Binario: 1110 0001

//-- Controlaremos el Skybot usando la constante SKYBOT
#define SKYBOT PORTB

//-- Definiciones para los motores. Estos valores definen
//-- los movimientos del robot
#define   AVANZA     0x1C
#define   ATRAS      0x16
#define   IZQUIERDA  0x1E 
#define   DERECHA    0x14 
#define   STOP       0x00

//-- Indicar el sensor a utilizar. Por defecto esta puesto el 3, pero se
//-- puede poner cualquier otro: 1,2 o 4.
#define   SENSOR SENSOR3

//-- Colores leidos por los sensores
#define NEGRO  1
#define BLANCO 0

//----------------------------
//- Comienzo del programa  
//----------------------------

void main(void)
{
  //-- configurar Skybot
  TRISB=CONF_SKYBOT;
    
  //-- Los motores del Skybot parados
  SKYBOT=STOP;

  //-- Bucle principal
  while(1) {
 
    //-- Sensor  lee blanco?
    if (SENSOR==BLANCO) {
      SKYBOT=AVANZA;           //-- si, avanzar
    } 
    else {
      SKYBOT=STOP;             //-- no, parar
    }
  }
}



