/*****************************************************************************/
/* mogollon.c.c  Julio-2007                                                  */
/*---------------------------------------------------------------------------*/
/* Ejemplo para el skybot                                                    */
/*---------------------------------------------------------------------------*/
/* Programa modelo para el concurso del "mogollon"                           */
/*---------------------------------------------------------------------------*/
/*  Andres Prieto-Moreno <andres@ifara.com>                                  */
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Javier Valiente <jvaliente@ifara.com>                                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>

//-- Utilizar el Skybot
#include "skybot.h"

//-- Usar las rutinas de pausa del temporizador 0
#include "timer0-delay.h"


//-- MOdificar esto para indicar la colocacion de los sensores
#define IZQUIERDO SENSOR4
#define DERECHO   SENSOR3

//-- Tiempo en segundos para esperar a que el algoritmo arranque
#define TIEMPO  2

void main(void)
{
  unsigned char i;

  //-- configurar Skybot
  configurar_skybot();
    
  //-- Inicialmente robot parado
  SKYBOT=STOP;

  //-- Configurar temporizador
  timer0_configurar();
 
  //-- Esperar 500ms y encender led
  timer0_delay(50);

  //-- Encender el led
  LED=ON;

  //-- Esperar a que se apriete el pulsador
  while (PULSADOR==NO_PULSADO);

  //-- Hacer que el led parpadee durante 5 segundos
  for (i=0; i<TIEMPO*2; i++) {
    LED = LED ^ 1;  //-- Cambiar el led de estado
    timer0_delay(50);
  }  

//-----------------------------------------------------------
//--- A continuacion colocar el algoritmo para el concurso
//--- del mogollon!! Se pone uno de EJEMPLO 
//-----------------------------------------------------------

  //-- ALGORITMO DE EJEMPLO
  //-- Si blanco-blanco --> recto
  //-- Si blanco-negro --> Girar izquierda durante un tiempo
  //-- Si negro-blanco --> Girar derecha durante un tiempo
  //-- Si negro-negro --> atras durante un tiempo

  //-- Bucle principal
  while(1) {

    if (IZQUIERDO==BLANCO  && DERECHO==BLANCO)  {      //-- Caso: Blanco-blanco
      SKYBOT=AVANZA;
    }
    else if (IZQUIERDO==BLANCO && DERECHO==NEGRO)  { //-- Caso: Blanco-negro
      SKYBOT=IZQUIERDA;
      timer0_delay(50);
    }
    else if (IZQUIERDO==NEGRO  && DERECHO==BLANCO) { //-- Caso: Negro-Blanco
      SKYBOT=DERECHA;
      timer0_delay(50);
    }
    else {                                           //-- Caso: negro-negro
      SKYBOT=ATRAS;
      timer0_delay(50);
    }
  }

}
