/*****************************************************************************/
/* linea.c  Julio-2007                                                       */
/*---------------------------------------------------------------------------*/
/* Ejemplo para el skybot                                                    */
/*---------------------------------------------------------------------------*/
/* Programa de seguimiento de linea para el robot Skybot                     */
/*---------------------------------------------------------------------------*/
/*  Andres Prieto-Moreno <andres@ifara.com>                                  */
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Javier Valiente <jvaliente@ifara.com>                                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>

//-- Utilizar el Skybot
#include "skybot.h"

//-- Modificar esto para indicar la colocacion de los sensores
#define IZQUIERDO SENSOR4
#define DERECHO   SENSOR3

void main(void)
{
  //-- configurar Skybot
  configurar_skybot();

  //-- Bucle principal
  while(1) {

    if (IZQUIERDO==NEGRO  && DERECHO==NEGRO)  {      //-- Caso: Negro-Negro
      SKYBOT=AVANZA;
    }
    else if (IZQUIERDO==BLANCO && DERECHO==NEGRO)  { //-- Caso: Blanco-negro
      SKYBOT=DERECHA;
    }
    else if (IZQUIERDO==NEGRO  && DERECHO==BLANCO) { //-- Caso: Negro-Blanco
      SKYBOT=IZQUIERDA;
    }
    else {                                           //-- Resto de casos
      SKYBOT=STOP;
    }
  }

}

