/*************************************************************************** */
/* ledp2.c      Julio-2007                                                   */
/*---------------------------------------------------------------------------*/
/* Ejemplo para la tarjeta SKYPIC                                            */
/*---------------------------------------------------------------------------*/
/* Hacer parpear el led de la Skypic. SE USA EL TIMER 0                      */
/*---------------------------------------------------------------------------*/
/*  Andres Prieto-Moreno <andres@ifara.com>                                  */
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Javier Valiente <jvaliente@ifara.com>                                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>

//-- Usar las rutinas de pausa del temporizador 0
#include "timer0-delay.h"

//-- Definiciones
#define SALIDA  0
#define LED       RB1    // Pin del led de la Skypic

void main(void)
{
  //-- Configurar LED
  TRISB1=SALIDA;

  //-- Configurar el temporizador 0
  timer0_configurar();

    
  //-- Bucle infinito
  while(1) {
    LED=LED^1;           //-- Cambiar led de estado
    timer0_delay(50);   //-- Pausa de 0.5 segundos
  }

}
