/*************************************************************************** */
/* ledp.c      Julio-2007                                                    */
/*---------------------------------------------------------------------------*/
/* Ejemplo para la tarjeta SKYPIC                                            */
/*---------------------------------------------------------------------------*/
/* Hacer parpear el led de la Skypic. No se utilizan los temporizadores      */
/*---------------------------------------------------------------------------*/
/*  Andres Prieto-Moreno <andres@ifara.com>                                  */
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Javier Valiente <jvaliente@ifara.com>                                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>

//-- Definiciones
#define SALIDA  0
#define LED       RB1    // Pin del led de la Skypic

//-- Cambiando este valor se modifica el tiempo de pausa
//-- 0xFFFF es la maxima y 0x0000 la minima
#define RETRASO 0xFFFF

//-- Contador para la pausa
unsigned int contador;

/**************************************************************************/
/* Rutina de pausa. Se hace que el contador vaya desde 0000 hasta retraso */
/* ENTRADAS:                                                              */
/*   -retraso: Indica el valor de la pausa. 0xFFFF es el valor maximo     */        
/**************************************************************************/
void pausa(unsigned int retraso)
{
  while (retraso>0) {
    retraso--;
  }  
}

void main(void)
{
  //-- Configurar LED
  TRISB1=SALIDA;

  //-- Bucle infinito
  while(1) {
    LED=LED^1;        //-- Cambiar led de estado
    pausa(RETRASO);   //-- Pausa
  }

}
