/*****************************************************************************/
/* contacto.c      Julio-2007                                                */
/*---------------------------------------------------------------------------*/
/* Ejemplo para el skybot                                                    */
/*---------------------------------------------------------------------------*/
/*  Ejemplo de prueba para los bumpers. El robot se convierte en una "lapa"  */
/*  y tiendo a pegarse a las objetos. Si los dos bumpers estan activados     */
/*  el robot se para. Cuando estan sueltos avanza. Si se activa el derecho   */
/*  gira a la derecha y si lo hace el izquierdo gira a la izquierda          */
/*---------------------------------------------------------------------------*/
/*  Andres Prieto-Moreno <andres@ifara.com>                                  */
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Javier Valiente <jvaliente@ifara.com>                                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>

#include "skybot.h"

#define BUMPER_IZDO BUMPER2  //Bumper izquierdo
#define BUMPER_DECHO BUMPER1 //Bumper derecha

//----------------------------
//-- Comienzo del programa  
//----------------------------

void main(void)
{
  //-- configurar Skybot
  configurar_skybot();

  //-- Bucle principal
  while(1) {
    if (BUMPER_IZDO==ON && BUMPER_DECHO==OFF) {
      SKYBOT=IZQUIERDA;
    }
    else if (BUMPER_IZDO==OFF && BUMPER_DECHO==ON) {
      SKYBOT=DERECHA;
    }
    else if (BUMPER_IZDO==OFF && BUMPER_DECHO==OFF) {
      SKYBOT=AVANZA;
    }
    else {
      SKYBOT=STOP;
      LED=ON;
    }
  }

}

