/*************************************************************************** */
/* conversor-ad1-leds.c                                                      */ 
/*---------------------------------------------------------------------------*/
/* Ejemplo para la tarjeta SKYPIC                                            */
/*---------------------------------------------------------------------------*/
/* CONVERSOR ANALOGICO-DIGITAL                                               */
/*---------------------------------------------------------------------------*/
/* Ejemplo de lectura del cana RA0 analogico. La muestra de 8 bits leida     */
/* se envia por el puerto C para ser visualizada en los leds                 */
/* Es necesario conectar una tarjeta Freeleds                                */
/* Si se supera el umbral del oscuridad se enciende el led de la Skypic      */
/* en caso contrario se apaga                                                */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

#include <pic16f876a.h>

#define LED       RB1    // Pin del led de la Skypic
#define SALIDA    0

//-- Definir el umbral de lo que consideramos como oscuridad
//-- Modificable por el usuario para adaptarlo al ambiente
#define UMBRAL_OSCURIDAD 0xFC

void conversor_ad_conf()
{
  //-- Configuracion del conversor analogico digital
  //-- Configurar RA0 como entrada analogica. El resto del puerto A
  //-- como digital
  ADCON1 = 0x0E;

  //-- Configurar pin RA0 como entrada
  TRISA0 = 1;

  //-- Leer los 8 bits mas significativos por ADRESH
  ADFM = 0;  
  
  //-- Seleccionar el canal analogico (RA0)
  ADCON0 = 0x00;

  //-- Encender conversor
  ADON=1;
}

unsigned char conversor_ad_read()
{
    //-- Poner flag a 0
    ADIF=0;

    //-- Que comience la conversion!!!
    GO=1;

    //-- Esperar a que finalice la conversion
    while(ADIF==0);

    //-- Devolver la muestra
    return ADRESH;
}

void main(void)
{
  unsigned char luz;

  //-- Configurar puerto C para salida
  TRISC = 0x00;

  //-- Configurar el conversor A/D
  conversor_ad_conf();

  //-- Configurar puerto B para poner el LED de salida
  TRISB1=SALIDA;

  while(1) {

    //-- Leer el sensor de luz
    luz = conversor_ad_read();

    //-- Enviar su valor a los leds del puerto C
    PORTC = luz;

    //-- Si hay oscuridad encender el led de la Skypic
    //-- La constante UMBRAL se debe ajustar segun la luz ambiente
    //-- El valor 0xFF es oscuridad total y 0x00 es iluminacion total
    //-- Si se supera el umbral de oscuridad se enciende el led, en otro 
    //-- caso se apaga
    if (luz>=UMBRAL_OSCURIDAD)
      LED=1;
    else
      LED=0;
  }
  
}



