/*****************************************************************************/
/* bumpers.c      Julio-2007                                                 */
/*---------------------------------------------------------------------------*/
/* Ejemplo para el skybot                                                    */
/*---------------------------------------------------------------------------*/
/*  Ejemplo de prueba para los bumpers.                                      */
/*  Al apretar un bumper se apaga el LED   ...........                       */
/*---------------------------------------------------------------------------*/
/*  Andres Prieto-Moreno <andres@ifara.com>                                  */
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Javier Valiente <jvaliente@ifara.com>                                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>

//-- Situacion de los bumpers
#define BUMPER1 RA1
#define BUMPER2 RA2

//-- Seleccionar el bumper a mostrar por el LED
#define BUMPER BUMPER1

//-- Definiciones
#define SALIDA  0
#define LED       RB1    // Pin del led de la Skypic

void main(void)
{
  //-- Configurar puerto B para poner el LED de salida
  TRISB1=SALIDA;

  //-- Configurar puerto A para entrada
  TRISA = 0xFF;
    
  //-- Configurar el puerto A para trabajar con los bumpers
  ADCON1=0x0E;

  while(1) {
    LED = BUMPER;
  }
}

