/*************************************************************************** */
/* skypad-test2.c                                                             */
/*---------------------------------------------------------------------------*/
/* Ejemplo para la tarjeta SKYPIC                                            */
/*---------------------------------------------------------------------------*/
/* Conectar la skypads al puerto A de la skypic y la freeleds al puerto B    */
/* El estado de 6 pulsadores de la skypad se podra ver en los leds de        */
/* la freeleds.                                                              */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

#include <pic16f876a.h>

#define LED RB1

void main(void)
{
  
  //-- Configurar puerto A para entrada digital
  ADCON1=0x06;
  TRISA = 0xFF;

  //-- Configurar puerto B para salida
  TRISB=0x00;

  while(1) {
    //-- Sacar por el puerto B los seis bits de menor peso del puerto A
    //-- El puerto A es de 6 bits, por eso los dos de mayor peso se ponen a cero
    PORTB=(~PORTA) & 0x3F;
  }

}

