/****************************************************************************************
 * Here's where you define the overall electronics setup for your machine.
 ****************************************************************************************/

//
// CHOOSE WHICH EXTRUDER YOU'RE USING:
//
//#define EXTRUDER_CONTROLLER_VERSION_2_0
//#define EXTRUDER_CONTROLLER_VERSION_2_1
#define EXTRUDER_CONTROLLER_VERSION_2_2

#define TEMPERATURE_SAMPLES 5
#define SERIAL_SPEED 38400

//the address for commands to listen to
#define RS485_ADDRESS 0
#define PACKET_TIMEOUT 100

/****************************************************************************************
 * Here's where you define the way your motors are driven.
 ****************************************************************************************/
//PWM
#define MOTOR_STYLE 0
//ENCODER
//#define MOTOR_STYLE 1 
//STEPPER
//define MOTOR_STYLE 2 

//do you want to reverse the motor?
#define DELAY_FOR_STOP 5
#define MOTOR_REVERSE_DURATION 300
#define MOTOR_FORWARD_DURATION 300

/****************************************************************************************
 * Here's where you define the speed PID behavior for an encoder
 ****************************************************************************************/
//#define INVERT_QUADRATURE
#define MIN_SPEED 50              //minimum PWM speed to use
#define MAX_SPEED 255             //maximum PWM speed to use
#define SPEED_ERROR_MARGIN 10     //our error margin (to prevent constant seeking)
#define SPEED_INITIAL_PGAIN 1     //our proportional gain.
#define SPEED_INITIAL_IGAIN 100   //our integral gain.
#define SPEED_INITIAL_DGAIN 10    //our derivative gain.


/****************************************************************************************
 * Here's where you define the configuration for the stepper.
 ****************************************************************************************/
#define MOTOR_STEPS 200              //number of steps per revolution
#define MOTOR_STEP_MULTIPLIER 2      //step multiplier (full = 1, half=2, etc.)

/****************************************************************************************
 * Sanguino Pin Assignment
 ****************************************************************************************/

//these are the pins for the v2.0 Extruder Controller
#if defined(EXTRUDER_CONTROLLER_VERSION_2_0) || defined(EXTRUDER_CONTROLLER_VERSION_2_1) || defined(EXTRUDER_CONTROLLER_VERSION_2_2)

#define ENCODER_A_PIN 2
#define ENCODER_B_PIN 3

#define RX_ENABLE_PIN 4
#define TX_ENABLE_PIN 16

#define MOTOR_1_SPEED_PIN 5
#define MOTOR_1_DIR_PIN 7
#define MOTOR_2_SPEED_PIN 6
#define MOTOR_2_DIR_PIN 8

#define SERVO1_PIN 9
#define SERVO2_PIN 10

#define HEATER_PIN 11
#define FAN_PIN 12
#define VALVE_PIN 15

#define THERMISTOR_PIN 3

#define DEBUG_PIN 13

#endif

//quadrature encoder behavior
#ifdef INVERT_QUADRATURE
#define QUADRATURE_INCREMENT speed_error--;
#define QUADRATURE_DECREMENT speed_error++;
#else
#define QUADRATURE_INCREMENT speed_error++;
#define QUADRATURE_DECREMENT speed_error--;
#endif
