#include <openrave-core.h>
#include <vector>
#include <cstring>
#include <sstream>
#include <math.h>
#include <pthread.h>

#include <boost/thread/thread.hpp>
#include <boost/bind.hpp>

using namespace OpenRAVE;
using namespace std;


void SetViewer(EnvironmentBasePtr penv, const string& viewername)
{
    RaveViewerBasePtr viewer = penv->CreateViewer(viewername);
    BOOST_ASSERT(!!viewer);

    // attach it to the environment:
    penv->AttachViewer(viewer);

    // finally you call the viewer's infinite loop (this is why you need a separate thread):
    bool showgui = true;
    viewer->main(showgui);

}


int main(int argc, char ** argv)
{
    // create the main environment
    EnvironmentBasePtr penv = CreateEnvironment(true);
    penv->StopSimulation();

    boost::thread thviewer(boost::bind(SetViewer,penv,"qtcoin"));

    {
        // lock the environment to prevent changes
        EnvironmentMutex::scoped_lock lock(penv->GetMutex());

        // load the scene
        penv->Load("./test14.xml");

    }

    //-- Get the physical engine
    PhysicsEngineBasePtr pe = penv->GetPhysicsEngine();

    //-- KinBody
    std::vector<KinBodyPtr> bodies;
    penv->GetBodies(bodies);




    while(1) {
        penv->StepSimulation(0.005);
        usleep(5000);
    }

    penv->Destroy(); // destroy
    return 0;
}
