#include <openrave-core.h>
#include <vector>
#include <cstring>
#include <sstream>

#include <pthread.h>

#include <boost/thread/thread.hpp>
#include <boost/bind.hpp>

using namespace OpenRAVE;
using namespace std;


void SetViewer(EnvironmentBasePtr penv, const string& viewername)
{
    RaveViewerBasePtr viewer = penv->CreateViewer(viewername);
    BOOST_ASSERT(!!viewer);

    // attach it to the environment:
    penv->AttachViewer(viewer);

    // finally you call the viewer's infinite loop (this is why you need a separate thread):
    bool showgui = true;
    viewer->main(showgui);

}

void servo_pos(EnvironmentBasePtr penv, KinBody::JointPtr joint, dReal ref)
{
    const dReal KP = 8.3;
    const dReal MaxError = 0.017453;
    dReal error;
    std::vector<dReal> angle;
    std::vector<dReal> pJointVelocities(1);
    do {
        penv->StepSimulation(0.01);
        usleep(20000);

        //-- Get the current angle
        joint->GetValues(angle);

        error = angle[0] - ref;
        dReal velocity = -error*KP;

        pJointVelocities[0]=velocity;
        penv->GetPhysicsEngine()->SetJointVelocity (joint, pJointVelocities);

    } while (abs(error)>MaxError);

    pJointVelocities[0]=0.0;
    penv->GetPhysicsEngine()->SetJointVelocity (joint, pJointVelocities);
}

int main(int argc, char ** argv)
{
    // create the main environment
    EnvironmentBasePtr penv = CreateEnvironment(true);

    boost::thread thviewer(boost::bind(SetViewer,penv,"qtcoin"));

    {
        // lock the environment to prevent changes
        EnvironmentMutex::scoped_lock lock(penv->GetMutex());

        // load the scene
        penv->Load("./test06.xml");

    }

    //-- KinBody
    std::vector<KinBodyPtr> bodies;
    penv->GetBodies(bodies);
    KinBodyPtr kinbody = bodies[0];

    //-- Get the physical engine
    PhysicsEngineBasePtr pe = penv->GetPhysicsEngine();

    //-- Get the joints
    const std::vector<KinBody::JointPtr>& vjoints = kinbody->GetJoints();
    KinBody::JointPtr joint = vjoints[0];

    penv->StopSimulation();

    char tecla;
    do {
      servo_pos(penv,joint,1.5708);

      cin >> tecla;

      servo_pos(penv,joint,-1.5708);

      cin >> tecla;

    } while(tecla!='q');

    cout << "FIN!!" << endl;

    penv->Destroy(); // destroy
    return 0;
}
