//-- Y1 module. Part FE
//-- Parameters:
// w: thickness. Typicall: 3
// M: Drills diameter. Typicall: 3

function FE_get_parameter(name) = dxf_dim(file="part-FE.dxf", name=name);

module part_FE(w=3,M=3) {

   yd = FE_get_parameter("yd");

   difference() {
     linear_extrude(file="part-FE.dxf", layer="exterior", height=w, center=true);

     translate([0,yd,0]) cylinder(r=M/2, h=W+10, $fn=16, center=true);    
  }
}
  

//-- Part thickness:
W=3;
translate ([0,0,W/2]) part_FE(W,3);

