//-- Y1 module. Part F
//-- Parameters:
// w: thickness. Typicall: 3
// M: Drills diameter. Typicall: 3

module part_F(w=3,M=3) {
  xd1 = dxf_dim(file = "part-F.dxf", name = "xd1");
   yd1 = dxf_dim(file = "part-F.dxf", name= "yd1");
  xd2 = dxf_dim(file = "part-F.dxf", name = "xd2");
  yd2 = dxf_dim(file = "part-F.dxf", name= "yd2");
  xd3 = dxf_dim(file = "part-F.dxf", name = "xd3");
  yd3 = dxf_dim(file = "part-F.dxf", name= "yd3");
  xd4 = dxf_dim(file = "part-F.dxf", name = "xd4");
  yd4 = dxf_dim(file = "part-F.dxf", name= "yd4");

  difference() {
     linear_extrude(file="part-F.dxf", layer="exterior", height=w, center=true);

      translate ([-xd1,yd1,0]) cylinder(h=w+10, r=M/2, center=true, $fn=16);
      translate ([-xd2,yd2,0]) cylinder(h=w+10, r=M/2, center=true, $fn=16);
      translate ([xd3,-yd3,0]) cylinder(h=w+10, r=M/2, center=true, $fn=16);
     translate ([xd4,-yd4,0]) cylinder(h=w+10, r=M/2, center=true, $fn=16);
  }
 
}
  

//-- Part thickness:
W=3;

//-- Locate the part on the z=0 plane
translate ([0,0,W/2]) part_F(W,3);

