//-- Y1 module. Part E
//-- Parameters:
// w: thickness. Typicall: 3
// M: Drills diameter. Typicall: 3

function E_get_parameter(name) = dxf_dim(file="part-E.dxf", name=name);

module part_E(w=3,M=3) {

   yd1 = E_get_parameter("yd1");
   yd2 = E_get_parameter("yd2");
   yd3 = E_get_parameter("yd3");
   ds = E_get_parameter("ds");

   difference() {
     linear_extrude(file="part-E.dxf", layer="exterior", height=w, center=true);

     translate([0,yd1,0]) cylinder(r=M/2, h=W+10, $fn=16, center=true);    
     translate([0,yd2,0]) cylinder(r=ds/2, h=W+10, $fn=16, center=true);    
     translate([0,yd3,0]) cylinder(r=M/2, h=W+10, $fn=16, center=true);    
  }
}
  

//-- Part thickness:
W=3;
translate ([0,0,W/2]) part_E(W,3);

