//-- Y1 module. Part B1
//-- Parameters:
// w: thickness. Typicall: 3
// M: Drills diameter. Typicall: 3

function B1_get_parameter(name) = dxf_dim(file="part-B1.dxf", name=name);


module part_B1(w=3,M=3) {
  xd = B1_get_parameter("xd");
  yd = B1_get_parameter("yd");
  difference() {
     linear_extrude(file="part-B1.dxf", layer="exterior", height=w, center=true);
     linear_extrude(file="part-B1.dxf", layer="interior", height=w+10, center=true);
     translate ([xd,yd,0]) cylinder(h=w+10, r=M/2, center=true, $fn=16);
     translate ([-xd,yd,0]) cylinder(h=w+10, r=M/2, center=true, $fn=16);
     translate ([-xd,-yd,0]) cylinder(h=w+10, r=M/2, center=true, $fn=16);
     translate ([xd,-yd,0]) cylinder(h=w+10, r=M/2, center=true, $fn=16);
  }
  
}

//-- Part thickness:
W=3;

//-- Locate the part on the z=0 plane
translate ([0,0,W/2]) part_B1(W,3);

