//-- Y1 module, built from its parts
use <Y1-module-body.scad>
use <Y1-module-head.scad>
use <part-FE.scad>
use <futaba.scad>
use <part-B1.scad>
use <part-B2.scad>
use <futaba_plate.scad>


//-- Thikness set to 3mm
W=3;

//-- Read some parameters
yd = FE_get_parameter("yd");
yg = FE_get_parameter("yg");
xg = FE_get_parameter("xg");
xF = B1_get_parameter("xF");
xE = B2_get_parameter("xE");
he = dxf_dim(file="futaba-main.dxf",name="he");
we = dxf_dim(file="futaba-ears.dxf", name="we");

//-- Locate the module with the origin between the body and the 
//-- head. The servo shaft is located on the x axis
translate([0,-xg,-W-yg-yd])
union() {

  //-- The body
  translate([0,0,W/2])
  y1_module_body(W);

  //-- The head
  translate([0,0,(yd+yg+W)*2])
  rotate([180,0,0])
  translate([0,0,W/2])
  y1_module_head(W);

  //-- The servo
  translate([xF-he+W,0,29])
  rotate([45,0,0])
  rotate([0,90,0]) 
  rotate([0,0,90])
  futaba();  
};


//-- Servo's plate
translate([xE+W,0,0])
rotate([0,90,0])
futaba_plate();
