/**************************************************************************/
/** Module sin.c                                                          */
/**-----------------------------------------------------------------------*/
/** Implementation of the trigonometric sine function by means of  tables */
/** This is necessary because there is a bug in SDCC (v2.8.0 and 2.9.0)   */
/** The negative floating points does not work. Therefore the             */
/**  mathematical library does not work properly either                   */
/**                                                                       */
/** This bug has been fixed in version 2.10. Instead of this module the   */
/** function sinf() from the mathematical library can be used             */
/**-----------------------------------------------------------------------*/
/** (c) Dr. Juan Gonzalez-Gomez.                                    */
/** Feb/2011                                                        */
/**-----------------------------------------------------------------*/
/** GPL license                                                     */
/********************************************************************/

//-- Specify the PIC micro-controller used in the Skycube board
#include <pic16f876a.h>

#include <float.h>
#include <math.h>

//-- Table with the sine values for the angles in the range [0,90]
__code static float tabla[]={
0.0,
0.017452, 0.034899, 0.052336, 0.069756, 0.087156, 0.10453, 0.12187, 0.13917, 0.15643, 0.17365, //- 01 - 10
0.19081,  0.20791,  0.22495,  0.24192,  0.25882,  0.27564, 0.29237, 0.30902, 0.32557, 0.34202, //- 11 - 20
0.35837,  0.37461,  0.39073,  0.40674,  0.42262,  0.43837, 0.45399, 0.46947, 0.48481, 0.50000, //- 21 - 30
0.51504,  0.52992,  0.54464,  0.55919,  0.57358,  0.58779, 0.60182, 0.61566, 0.62932, 0.64279, //- 31 - 40
0.65606,  0.66913,  0.68200,  0.69466,  0.70711,  0.71934, 0.73135, 0.74314, 0.75471, 0.76604, //- 41 - 50
0.77715,  0.78801,  0.79864,  0.80902,  0.81915,  0.82904, 0.83867, 0.84805, 0.85717, 0.86603, //- 51 - 60
0.87462,  0.88295,  0.89101,  0.89879,  0.90631,  0.91355, 0.92050, 0.92718, 0.93358, 0.93969, //- 61 - 70
0.94552,  0.95106,  0.95630,  0.96126,  0.96593,  0.97030, 0.97437, 0.97815, 0.98163, 0.98481, //- 71 - 80
0.98769,  0.99027,  0.99255,  0.99452,  0.99619,  0.99756, 0.99863, 0.99939, 0.99985, 1.00000, //- 81 - 90
};


/**************************************************************************/
/** Calculate A*sin(x). The result is rounded to an integer number        */
/** ENTRADAS:                                                             */
/**   -A: Amplitud in degrees (0,90)                                      */
/**   -x: Phase. Range: [0,360]. Negative phases are also valid           */
/*************************************************************************/
int sin(int A, int x)
{
  volatile int result;
  int sign1=1;
  int sign;


 //-- If the phase is negative, take it as possitive but set the variable
 //-- sign equal to -1. The sine() function is odd
 if (x>=0) sign=1;
 else {
    sign=-1;
    x=-x;
 }

  //-- The phase should be in the range 0-360
  x = x % 360;

  //-- Calculate the equivalente phase in the first quadrant. Calculate the
  //-- corresponding sign

  //-- Second quadrant
  if (x>90 && x<=180) {
    x = 180-x;
  }

  //-- Third quadrant
  if (x>180 && x<=270) {
    x = x - 180;
    sign1=-1;
  }

  //-- Fourth quadrant
  if (x>270 && x<=360) {
    x = 360 -x;
    sign1=-1;
  }

  //-- Calculate the result
  result = (int) (A*tabla[x]);

  //-- Return the result with the correct sign
  return sign*sign1*result;
}

