/********************************************************************/
/** Servo module                                                    */
/**-----------------------------------------------------------------*/
/** (c) Andres Prieto-Moreno                                        */
/** (c) Dr. Juan Gonzalez-Gomez.                                    */
/** Feb/2011                                                        */
/**-----------------------------------------------------------------*/
/** GPL license                                                     */
/********************************************************************/

#ifndef SERVOS_H
#define SERVOS_H

//-- Constant used for enabling the servos
//-- They sould be used with the servos_enable() and servos_disable() functions
#define SERVO1 0x01
#define SERVO2 0x02
#define SERVO3 0x04
#define SERVO4 0x08
#define SERVO5 0x10
#define SERVO6 0x20
#define SERVO7 0x40
#define SERVO8 0x80
#define SERVOS_ALL  0xFF
#define SERVOS_NONE 0x00

//-- Servo labels. Used with the servos_set_raw() and servos_set() functions
#define S1 0
#define S2 1
#define S3 2
#define S4 3
#define S5 4
#define S6 5
#define S7 6
#define S8 7

//-- Interface functions!
void servos_init(void);
void servos_enable_mask(unsigned char mascara);
void servos_enable(unsigned char servo);
void servos_disable(unsigned char servo);

int servos_degrees2time(int grados);
void servos_set_raw(int servo, int tiempo);
void servos_set(int servo, int grados);
void servos_intr();


#endif

