/**************************************************************************/
/** Experiment 5: Cube6 Race!     ROBOT 2,  SEGMENT 1                     */
/**-----------------------------------------------------------------------*/
/** Locomotion of 5 Cube6 robots with different phase differences         */
/** Given that each segment consist of three modules, the initial phase   */
/** of the second segment is 3 * Phase difference.                        */
/**  The initial phase of segment 1 is taken as 0                         */
/**                                                                       */
/**  The parameters of the gaits to be tested are:                        */
/**                                                                       */
/**  Phase diff:    60    80    100   120    140                          */
/**  k:             1     1.3    1.6   2     2.3                          */
/**  Segment 1                                                            */
/**    P0           0      0      0    0       0                          */
/**  Segment 2                                                            */
/**    P0           180   240    300   0      60                          */
/**                                                                       */
/** --------------------------------------------------------------------- */
/** (c) Dr. Juan Gonzalez-Gomez.                                          */
/** Feb/2011                                                              */
/**-----------------------------------------------------------------------*/
/** GPL license                                                           */
/**************************************************************************/
//-- Specify the PIC micro-controller used in the Skycube board
#include <pic16f876a.h>

//-- Oscillator library
#include "oscillator.h"

//-- Location of the test button
#define TEST_BUTTON RA0

//-- Constant for determining the test button state
#define PRESSED  0
#define RELEASED 1

/**************************************/
/** LOCOMOTION PARAMETERS             */
/**************************************/
//-- This parameters determine the locomotion. They can be changed by the
//-- user. It is not necessary to change the code, just this parameters
#define A  40     //-- Amplitude
#define PD  -60   //-- Phase diff. between two consecutive virtual servos
#define P0  0     //-- Initial phase
#define I   4     //-- Phase Increment
#define DT  10    //-- Locomotion duration (in periods)

/**********************************************/
/** GLOBAL VARIABLES                          */
/**********************************************/

//-- VIRTUAL SERVOS!
//-- For locomotion porposes we will think of robots as composed of virtual
//-- modules. Virtual module 1 is the tail, 2 is in the middle and 3 is the head
//-- The mapping between the virtual servos and the PWM channel to witch they are
//-- attached is determined by the v variable

//-- A value of '0' means module not used
//-- Virtual servos:              1  2  3
unsigned char v[]={0,             2, 4, 6};

//-- The meaning of the previous assigment is the following:
//-- Only the virtual servo 1 is used, that is connectec to the pwm channel 4


/** VIRTUAL SERVOS PARAMETERS **/

//-- Phase increment for all the servos
//-- Seq number     0      1
__code int INC[] = {0,     I};

//-- Duration of each oscillation mode (in periods)
__code int NT[]  = {0,     DT};

//-- Parameters for VIRTUAL MODULE 1
__code int A1[]  = {A,    A};
__code int O1[]  = {0,     0};
__code int P1[]  = {P0,    P0};

//-- Parameters for VIRTUAL MODULE 2
__code int A2[]  =  {A,   A};
__code int O2[]  =  {0,    0};
__code int P12[]  = {PD,   PD};

//-- Parameters for VIRTUAL MODULE 3
__code int A3[]  =  {A,  A};
__code int O3[]  =  {0,    0};
__code int P13[]  = {2*PD, 2*PD};

/*******************************/
/** VARIABLES IMPORTED         */
/** From the OCILLATOR module  */
/*******************************/
extern int oscillator_periods;
extern int oscillator_new_period;


//----------------------------
//- MAIN PROGRAM
//----------------------------

void main(void)
{
  //-- The variable m is used to store the current oscillation
  unsigned char m=0;

  //-- Get the number of oscillations configured by the user
  unsigned char TAM=sizeof(A1)/sizeof(int);

  //-- Oscillator module initialization
  oscillator_init();

  //-- Set the parameters of the virtual servos
  oscillator_set_params(0);

  //-- Button configuration
  //-- The RA0 bit is configured as a digital input
  ADCON1=0x06;
  TRISA0 = 1;


  //----------------------
  //-- Main loop
  //----------------------
  while (1) {

     //-- Calculate module positions from the Oscillators
     oscillator_pos();

     //-- Check if the test button has been pressed
    if (TEST_BUTTON==PRESSED) {

      //-- Change to the following oscillation mode
      m = (m+1) % TAM;

      //-- Set the new oscillators parameters
      oscillator_set_params(m);

      //-- Wait until the test button is released
      while(TEST_BUTTON==PRESSED);
    }

    //-- Check if time has elapsed. If so, change the oscillation mode
    if (oscillator_new_period==1 && oscillator_periods>=NT[m]) {

      //-- Reset the variables
      oscillator_new_period=0;
      oscillator_periods=0;

      //-- Change to the following oscillation mode
      m = (m+1) % TAM;

      //-- Set the new oscillators parameters
      oscillator_set_params(m);
    }
  }

}
