/**************************************************************************/
/** Experiment 3: the PP RACE.    ROBOT 8                                 */
/**-----------------------------------------------------------------------*/
/** Locomotion of 10 Minicube-I modular robots (PP configurations)        */
/** The goal is to determine empirically how affect the phase difference  */
/** to the locomotion                                                     */
/**                                                                       */
/** 10 Minicube-I robots will be programmed with the same frecuency,      */
/** amplitude and offset (offset=0). Each robot will have its own phase   */
/** difference:                                                           */
/**                                                                       */
/**  Robots      1    2    3    4   5     6     7     8     9    10       */
/**  Phase diff  0    20  40   60   80   100   120   140   160   180      */
/**                                                                       */
/**  Which one will travelled the maximum distance?                       */
/**                                                                       */
/** NOTE: The robot trajectory should be a straight line, but             */
/**   depending on the surface the robot it can be an arc                 */
/** --------------------------------------------------------------------- */
/** (c) Dr. Juan Gonzalez-Gomez.                                          */
/** Feb/2011                                                              */
/**-----------------------------------------------------------------------*/
/** GPL license                                                           */
/**************************************************************************/
//-- Specify the PIC micro-controller used in the Skycube board
#include <pic16f876a.h>

//-- Oscillator library
#include "oscillator.h"

//-- Location of the test button
#define TEST_BUTTON RA0

//-- Constant for determining the test button state
#define PRESSED  0
#define RELEASED 1

/**************************************/
/** LOCOMOTION PARAMETERS             */
/**************************************/
//-- This parameters determine the locomotion. They can be changed by the
//-- user. It is not necessary to change the code, just this parameters
#define A  50     //-- Amplitude
#define O   0     //-- Offset
#define PD  0     //-- Phase diff. between Virtual servo 1 and 2
#define I   5     //-- Phase Increment
#define DT  20    //-- Locomotion duration (in periods)

/**********************************************/
/** GLOBAL VARIABLES                          */
/**********************************************/

//-- VIRTUAL SERVOS!
//-- For locomotion porposes we will think of robots as composed of virtual
//-- modules. Virtual module 1 is the tail, 2 is in the middle and 3 is the head
//-- The mapping between the virtual servos and the PWM channel to witch they are
//-- attached is determined by the v variable

//-- A value of '0' means module not used
//-- Virtual servos:              1  2  3
unsigned char v[]={0,             2, 4, 0};

//-- The meaning of the previous assigment is the following:
//-- Only the virtual servo 1 is used, that is connectec to the pwm channel 4


/** VIRTUAL SERVOS PARAMETERS **/

//-- Phase increment for all the servos
//-- Seq number     0   1
__code int INC[] = {0,  I};

//-- Duration of each oscillation mode (in periods)
__code int NT[]  = {DT, DT};

//-- Parameters for VIRTUAL MODULE 1
__code int A1[]  = {A, A};
__code int O1[]  = {O, O};
__code int P1[]  = {0, 0};

//-- Parameters for VIRTUAL MODULE 2
__code int A2[]  =  {A,  A};
__code int O2[]  =  {O,  O};
__code int P12[]  = {0,  PD};

//-- Parameters for VIRTUAL MODULE 3 (not used)
__code int A3[]  =  {0,  0};
__code int O3[]  =  {0,  0};
__code int P13[]  = {0,  0};

/*******************************/
/** VARIABLES IMPORTED         */
/** From the OCILLATOR module  */
/*******************************/
extern int oscillator_periods;
extern int oscillator_new_period;


//----------------------------
//- MAIN PROGRAM
//----------------------------

void main(void)
{
  //-- The variable m is used to store the current oscillation
  unsigned char m=0;

  //-- Get the number of oscillations configured by the user
  unsigned char TAM=sizeof(A1)/sizeof(int);

  //-- Oscillator module initialization
  oscillator_init();

  //-- Set the parameters of the virtual servos
  oscillator_set_params(0);

  //-- Button configuration
  //-- The RA0 bit is configured as a digital input
  ADCON1=0x06;
  TRISA0 = 1;


  //----------------------
  //-- Main loop
  //----------------------
  while (1) {

     //-- Calculate module positions from the Oscillators
     oscillator_pos();

     //-- Check if the test button has been pressed
    if (TEST_BUTTON==PRESSED) {

      //-- Change to the following oscillation mode
      m = (m+1) % TAM;

      //-- Set the new oscillators parameters
      oscillator_set_params(m);

      //-- Wait until the test button is released
      while(TEST_BUTTON==PRESSED);
    }

    //-- Check if time has elapsed. If so, change the oscillation mode
    if (oscillator_new_period==1 && oscillator_periods==NT[m]) {

      //-- Reset the variables
      oscillator_new_period=0;
      oscillator_periods=0;

      //-- Change to the following oscillation mode
      m = (m+1) % TAM;

      //-- Set the new oscillators parameters
      oscillator_set_params(m);
    }
  }

}
