/**************************************************************************/
/** Experiment 2 (the Big wave)   GROUP 6                                 */
/**-----------------------------------------------------------------------*/
/** 30 modules in the ground oscillating, generating a big wave           */
/** The modules are divided into 10 groups of 3 modules each              */
/** Each group is controlled by 1 Skycube board.                          */
/** The nomenclature for each group is the following:                     */
/**                                                                       */
/**   S1: Virtual servo 1. Located in the left                            */
/**   S2: Virtual servo 2. Located in the middle                          */
/**   S3: Virtual servo 3. Located in the right                           */
/**                                                                       */
/** There will be generated waves with k=0,0.5,1,2,3,4,5 and 10           */
/**                                                                       */
/** The equation for the calculating the phase difference is:             */
/** Phase_diff = 360*k/M, where M is 30 in this experiment                */
/**                                                                       */
/** The phase of the virtual servo 1 of each group is given by            */
/** the equation:                                                         */
/**                 phi = 3*(i-1)*360*k/M                                 */
/** where i is the group number (from 1 to 10)                            */
/**                                                                       */
/**                  k=0,  k=0.5,  k=1,  k=2,  k=3,  k=4,  k=5,  k=10     */
/**                ----------------------------------------------------   */
/**  P12              0      6      12    24    36    48    60   120      */
/**  P13 = 2*P12      0      12     24    48    72    96   120   240      */
/**  ------------------------------------------------------------------   */
/**  (Group 1)  P1:   0      0      0      0     0     0     0    0       */
/**  (Group 2)  P1:   0      18     36     72    108   144   180  0       */
/**  (Group 3)  P1:   0      36     72    144    216   288   0    0       */
/**  (Group 4)  P1:   0      54    108    216    324   72    180  0       */
/**  (Group 5)  P1:   0      72    144    288    72    216   0    0       */
/**  (Group 6)  P1:   0      90    180     0     180   0     180  0       */
/**  (Group 7)  P1:   0      108   216    72     288   144   0    0       */
/**  (Group 8)  P1:   0      126   252   144     36    288   180  0       */
/**  (Group 9)  P1:   0      144   288   216     144   72    0    0       */
/**  (Group 10) P1:   0      162   324   288     252   216   180  0       */
/**                                                                       */
/**  This table has been calculated with the octave script: Exp2_table.m  */
/** --------------------------------------------------------------------- */
/** (c) Dr. Juan Gonzalez-Gomez.                                          */
/** Feb/2011                                                              */
/**-----------------------------------------------------------------------*/
/** GPL license                                                           */
/**************************************************************************/
//-- Specify the PIC micro-controller used in the Skycube board
#include <pic16f876a.h>

//-- Oscillator library
#include "oscillator.h"

//-- Location of the test button
#define TEST_BUTTON RA0

//-- Constant for determining the test button state
#define PRESSED  0
#define RELEASED 1

/**************************************/
/** EXPERIMENT CONSTANTS              */
/**************************************/
#define A  40   //-- Amplitude
#define O   0   //-- Offset
#define DT  2   //-- DuraTion (in periods)
#define I   5   //-- Phase Increment


/**********************************************/
/** GLOBAL VARIABLES                          */
/**********************************************/

//-- VIRTUAL SERVOS!
//-- For locomotion porposes we will think of robots as composed of virtual
//-- modules. Virtual module 1 is the tail, 2 is in the middle and 3 is the head
//-- The mapping between the virtual servos and the PWM channel to witch they are
//-- attached is determined by the v variable

//-- A value of '0' means module not used
//-- Virtual servos:              1  2  3
unsigned char v[]={0,             4, 2, 6};

//-- The meaning of the previous assigment is the following:
//-- Only the virtual servo 1 is used, that is connectec to the pwm channel 4


/** VIRTUAL SERVOS PARAMETERS **/

//--- Waves generated:
//---            k=0, k=0.5, k=1, k=2, k=3, k=4, k=5, k=10

//-- Phase increment for all the servos
//-- Seq number     0   1   2   3   4   5    6    7     8
__code int INC[] = {0,  I,  I,  I,  I,  I,   I,   I,    I};

//-- Duration of each oscillation mode (in periods)
__code int NT[]  = {DT, DT, DT, DT, DT, DT,  DT,  DT,   DT};

//-- Parameters for VIRTUAL MODULE 1
__code int A1[]  = {A,  A,  A,  A,  A,   A,   A,   A,    A};
__code int O1[]  = {O,  O,  O,  O,  O,   O,   O,   O,    O};
__code int P1[]  = {0,  0,  0,  0,  0,   0,   0,   0,    0};

//-- Parameters for VIRTUAL MODULE 2
__code int A2[]  =  {A,  A,  A,  A,  A,  A,   A,   A,    A};
__code int O2[]  =  {O,  O,  O,  O,  O,  O,   O,   O,    O};
__code int P12[]  = {0,  0,  6, 12, 24,  36,  48,  60,   120};

//-- Parameters for VIRTUAL MODULE 3
__code int A3[]  =  {A,  A,  A,  A,  A,  A,   A,   A,    A};
__code int O3[]  =  {O,  O,  O,  O,  O,  O,   O,   O,    O};
__code int P13[]  = {0,  0,  12, 24, 48, 72,  96,  120, 240};

/*******************************/
/** VARIABLES IMPORTED         */
/** From the OCILLATOR module  */
/*******************************/
extern int oscillator_periods;
extern int oscillator_new_period;


//----------------------------
//- MAIN PROGRAM
//----------------------------

void main(void)
{
  //-- The variable m is used to store the current oscillation
  unsigned char m=0;

  //-- Get the number of oscillations configured by the user
  unsigned char TAM=sizeof(A1)/sizeof(int);

  //-- Oscillator module initialization
  oscillator_init();

  //-- Set the parameters of the virtual servos
  oscillator_set_params(0);

  //-- Button configuration
  //-- The RA0 bit is configured as a digital input
  ADCON1=0x06;
  TRISA0 = 1;


  //----------------------
  //-- Main loop
  //----------------------
  while (1) {

     //-- Calculate module positions from the Oscillators
     oscillator_pos();

     //-- Check if the test button has been pressed
    if (TEST_BUTTON==PRESSED) {

      //-- Change to the following oscillation mode
      m = (m+1) % TAM;

      //-- Set the new oscillators parameters
      oscillator_set_params(m);

      //-- Wait until the test button is released
      while(TEST_BUTTON==PRESSED);
    }

    //-- Check if time has elapsed. If so, change the oscillation mode
    if (oscillator_new_period==1 && oscillator_periods==NT[m]) {

      //-- Reset the variables
      oscillator_new_period=0;
      oscillator_periods=0;

      //-- Change to the following oscillation mode
      m = (m+1) % TAM;

      //-- Set the new oscillators parameters
      oscillator_set_params(m);
    }
  }

}
