/*******************************************************************/
/** blinking-led.c                                                 */
/**----------------------------------------------------------------*/
/** This program blinks the green led on the skycube board         */
/**----------------------------------------------------------------*/
/** (c) Dr. Juan Gonzalez-Gomez. Feb-2011                          */
/**----------------------------------------------------------------*/
/** GPL license                                                    */
/*******************************************************************/
//-- Specify the PIC micro-controller used in the Skycube board
#include <pic16f876a.h>

//-- The green led in the Skycube board is located on bit RB1
#define LED RB1

//-- Configure a pin as output
#define OUTPUT  0

//-- Value used for setting the delay
#define DELAY 0xFFFF

/***************************************************************************/
/** Simple Delay function                                                  */
/** No timers are used. Just a simple counter                              */
/**                                                                        */
/** INPUTS:                                                                */
/**   -delay: 16-bits number                                               */
/***************************************************************************/
void delay_simple(unsigned int delay)
{

  while (delay>0) {
    delay--;
  }
}

void main(void)
{
  //-- Configure the Port B bit 1 as an output
  TRISB1 = OUTPUT;

  //-- Main loop
  while(1) {
    LED^=1;                 //-- Change the led state
    delay_simple(DELAY);    //-- delay
  }

}
