/*******************************************************************/
/** Test-servos-1.c                                                */
/**----------------------------------------------------------------*/
/** Example of use of the module servos.                           */
/** It moves the servo 2 to the positions: 45 and -45 degrees      */
/**----------------------------------------------------------------*/
/** (c) Dr. Juan Gonzalez-Gomez.                                   */
/** (c) Andres Prieto-Moreno                                       */
/** Feb/2011                                                       */
/**----------------------------------------------------------------*/
/** GPL license                                                    */
/*******************************************************************/

//-- Specify the PIC micro-controller used in the Skycube board
#include <pic16f876a.h>

//-- The servo module is being used
#include <servos.h>


/*******************************************************/
/**  INTERRUPTIONS SERVICE ROUTINE                     */
/*******************************************************/
void intr(void) interrupt 0
{
  //-----------------------------------------------------------
  //-- Interruption routine service of timer0 for generating
  //-- de PWM signals for the servos. It is implemented in the
  //-- servo module
  //-----------------------------------------------------------
  if (T0IF==1)
    servos_intr();

}

#define DELAY 0xFFFF

//-- A simple function for generating a busy-wait delay
void delay_simple (unsigned int delay)
{
  while (delay>0) {
    delay--;
  }
}

//-- A simple delay function for generating busy-wait delays
//-- It just call the delay_simple function for generating
//-- longer delays
void delay_simple2(unsigned char ticks)
{
  for (;ticks>0; ticks--)
    delay_simple(DELAY);
}


//----------------------------
//- Main program
//----------------------------

void main(void)
{
  //-- Initialize the servo module
  servos_init();

  //-- Enable all the servos. However in this example only one servo is moved
  servos_enable_mask(SERVOS_ALL);

  //-- Enable the global interrupts. Now the PWM signals for controlling the
  //-- servos are being generated
  GIE=1;

  //----------------------
  //-- Main loop
  //----------------------
  while (1) {

    //-- Move the Servo 2 to 45 degrees
    servos_set(S2,45);
    delay_simple2(14);

    //-- Mover the Servo 2 to -45 degrees
    servos_set(S2,-45);
    delay_simple2(14);
  }

}




