/*******************************************************************/
/** Test-oscillations-3.c                                          */
/**----------------------------------------------------------------*/
/** Example of generating sinusoidal oscillations for UNIMOD       */
/** USING THE OSCILLATOR library                                   */
/** Example of different oscillations. Pressing the test button    */
/** the oscillation is changed                                     */
/**----------------------------------------------------------------*/
/** (c) Dr. Juan Gonzalez-Gomez.                                   */
/** Feb/2011                                                       */
/**----------------------------------------------------------------*/
/** GPL license                                                    */
/*******************************************************************/
//-- Specify the PIC micro-controller used in the Skycube board
#include <pic16f876a.h>

//-- Oscillator library
#include "oscillator.h"

//-- Location of the test button
#define TEST_BUTTON RA0

//-- Constant for determining the test button state
#define PRESSED  0
#define RELEASED 1


/**********************************************/
/** GLOBAL VARIABLES                          */
/**********************************************/

//-- VIRTUAL SERVOS!
//-- For locomotion porposes we will think of robots as composed of virtual
//-- modules. Virtual module 1 is the tail, 2 is in the middle and 3 is the head
//-- The mapping between the virtual servos and the PWM channel to witch they are
//-- attached is determined by the v variable

//-- A value of '0' means module not used
//-- Virtual servos:              1  2  3
unsigned char v[]={0,             4, 0, 0};

//-- The meaning of the previous assigment is the following:
//-- Only the virtual servo 1 is used, that is connectec to the pwm channel 4


/** VIRTUAL SERVOS PARAMETERS **/

//-- Phase increment for all the servos
//-- Seq number     0   1    2
__code int INC[] = {0,  5,   6};

//-- Parameters for VIRTUAL MODULE 1
__code int A1[]  = {40, 40, 40};
__code int O1[]  = {30, 30,  0};
__code int P1[]  = {0,  0,  0};


//-- Virtual modules 2 and 3 are not used in this example
//-- Nevertheless it is important to all the VIRTUAL MODULES HAVE THE
//-- SAME SIZE!!!

//-- Parameters for VIRTUAL MODULE 2 (not used in this example)
__code int A2[]  =  {0,   0,  0};
__code int O2[]  =  {0,   0,  0};
__code int P12[]  = {0,   0,  0};  //-- Phase diff. between V module 1 and 2

//-- Parameters for VIRTUAL MODULE 3 (not used in this example)
__code int A3[]  =  {0,   0,  0};
__code int O3[]  =  {0,   0,  0};
__code int P13[]  = {0,   0,  0};  //-- Phase diff. between V module 1 and 3


//----------------------------
//- MAIN PROGRAM
//----------------------------

void main(void)
{
  //-- The variable m is used to store the current oscillation
  unsigned char m=0;

  //-- Get the number of oscillations configured by the user
  unsigned char TAM=sizeof(A1)/sizeof(int);

  //-- Oscillator module initialization
  oscillator_init();

  //-- Set the parameters of the virtual servos
  oscillator_set_params(0);

  //-- Button configuration
  //-- The RA0 bit is configured as a digital input
  ADCON1=0x06;
  TRISA0 = 1;


  //----------------------
  //-- Main loop
  //----------------------
  while (1) {

     //-- Calculate module positions from the Oscillators
     oscillator_pos();

     //-- Check if the test button has been pressed
    if (TEST_BUTTON==PRESSED) {

      //-- Change to the following oscillation mode
      m = (m+1) % TAM;

      //-- Set the new oscillators parameters
      oscillator_set_params(m);

      //-- Wait until the test button is released
      while(TEST_BUTTON==PRESSED);
    }
  }
}
