/*******************************************************************/
/** Test-oscillations-2.c                                          */
/**----------------------------------------------------------------*/
/** Example of generating sinusoidal oscillations for UNIMOD       */
/** USING THE OSCILLATOR library                                   */
/**----------------------------------------------------------------*/
/** (c) Dr. Juan Gonzalez-Gomez.                                   */
/** Feb/2011                                                       */
/**----------------------------------------------------------------*/
/** GPL license                                                    */
/*******************************************************************/
//-- Specify the PIC micro-controller used in the Skycube board
#include <pic16f876a.h>

//-- Oscillator library
#include "oscillator.h"

/**********************************************/
/** GLOBAL VARIABLES                          */
/**********************************************/

//-- VIRTUAL SERVOS!
//-- For locomotion porposes we will think of robots as composed of virtual
//-- modules. Virtual module 1 is the tail, 2 is in the middle and 3 is the head
//-- The mapping between the virtual servos and the PWM channel to witch they are
//-- attached is determined by the v variable

//-- A value of '0' means module not used
//-- Virtual servos:              1  2  3
unsigned char v[]={0,             4, 0, 0};

//-- The meaning of the previous assigment is the following:
//-- Only the virtual servo 1 is used, that is connectec to the pwm channel 4


/** VIRTUAL SERVOS PARAMETERS **/

//-- Phase increment for all the servos
__code int INC[] = {5};

//-- Parameters for VIRTUAL MODULE 1
__code int A1[]  = {40};
__code int O1[]  = {40};
__code int P1[]  = {0};

//-- Parameters for VIRTUAL MODULE 2 (not used in this example)
__code int A2[]  = {0};
__code int O2[]  = {0};
__code int P12[]  = {0};  //-- Phase diff. between V module 1 and 2

//-- Parameters for VIRTUAL MODULE 3 (not used in this example)
__code int A3[]  = {0};
__code int O3[]  = {0};
__code int P13[]  = {0};  //-- Phase diff. between V module 1 and 3


//----------------------------
//- MAIN PROGRAM
//----------------------------

void main(void)
{

  //-- Oscillator module initialization
  oscillator_init();

  //-- Set the parameters of the virtual servos
  oscillator_set_params(0);

  //----------------------
  //-- Main loop
  //----------------------
  while (1) {

     //-- Calculate module positions from the Oscillators
     oscillator_pos();
  }
}
