/*************************************************************************** */
/* timer2.c  (c) Juan Gonzalez. Abril 2009                                   */
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>

/**************************************************************************/
/* Configuracion del timer 2 para obtener pausas de 1ms. La formula para  */
/* calcular el valor del comparador para generar pausas de 1ms es:        */
/*                                                                        */
/* pausa (usec) = 3.2 (usec) * n * ps, donde                              */
/*                                                                        */
/* n es el numero a poner en el comparador y ps el valor del post-scaler  */
/* Fijando el post-scaler a 2 (el prescaler a 16 por lo que se obtienen   */
/* tics de 3.2 usec) se tiene que n = 156                                 */
/**************************************************************************/
void timer2_init(void)
{
  //-- Configurar prescaler a 16:  Tics de 3.2 micro-seg
  T2CKPS1=1;
  T2CKPS0=1;

  //-- Post-scaler a 2
  TOUTPS0=1;

  //-- Comparador inicializado a 156
  PR2=156;

  //-- Activar timer2
  TMR2ON=1;

  //-- Flag de interrupcion a 0
  TMR2IF=0;
}

/*******************************************/
/* Realizar un retardo de ms milisegundos  */
/* Se usa el timer 2                       */
/*******************************************/
void timer2_delay(unsigned int ms)
{
  unsigned int i;

  //-- Inicializar el flag. de int. del timer2
  TMR2IF=0;

  //-- Timer2 a 0
  TMR2=0;

  for(i=0; i<ms; i++) {

    //-- Espera de 1ms
    while(TMR2IF==0);

    //-- Poner flag a 0
    TMR2IF=0;
  }
}


