/*****************************************************************************/
/* test-servos.c  Noviembre-2010                                             */
/*---------------------------------------------------------------------------*/
/* Ejemplo de uso del modulo servos.c para posicionar sevos                  */
/* Implementado para la tarjeta Skypic/Skycube 1.0 a 20MHz                   */
/*---------------------------------------------------------------------------*/
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Andres Prieto-Moreno <andres@iearobotics.com>                            */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>
#include "servos.h"


/**********************************************/
/* VARIABLES GLOBALES                         */
/**********************************************/
static char pos_fix[8]={0,0,0,0,0,0,0,0};

//-- Acceso a las posiciones de los servos
extern volatile unsigned char pos_servos[8];
extern unsigned char indice;
extern unsigned char tic;
extern unsigned char servo_actual; 

/*******************************************************/
/* RUTINA DE ATENCION A LAS INTERRUPCIONES             */
/*******************************************************/
void intr(void) interrupt 0
{
    
  //---------------------------------------------------------------
  //-- Rutina de servicio del timer0 para actualizar las senales
  //-- de PWM
  //-----------------------------------------------------------
  if (T0IF==1)
    servos_intr();

}

#define RETRASO 0xFFFF


//-- Realizar una pausa mediante espera activa
void pausa(unsigned int retraso)
{
  while (retraso>0) {
    retraso--;
  }  
}

void pausa2(unsigned char ticks)
{
  for (;ticks>0; ticks--)
    pausa(RETRASO);
}



//----------------------------
//- Comienzo del programa  
//----------------------------

void main(void)
{ 
  //-- Inicializacion
  servos_init();       //-- Servos

  //-- establecer el estado inicial de las mascaras
  servos_enable_mask(0xff);

  //-- Configurar puerto A como puerto Digital
  //-- Se usa para depurar con la Freeleds conectrada al puerto A
  ADCON1=0x06;
  TRISA=0x00;
  PORTA=0x00;

  //-- Interrupciones globales
  GIE=1;

  //----------------------
  //-- Bucle principal
  //----------------------
  while (1) {

    //-- OJO! El numero de servo a colocar en la funcion servos_set va entre 0 y 7
    //-- En la Skycube las serigrafias son del servo 1 al 8. 
    //-- Para mover el servo conectado al numero 2 en la skycube, hay que usar el indice 1

    //-- Mover el servo 2 a la posicion de 80 grados y esperar
    servos_set(1,80);
    pausa2(14);

    //-- Mover el servo 2 a la posicion -80 grados y esperar
    servos_set(1,-80);
    pausa2(14);
  } 

}




