/*****************************************************************************/
/* test-hypercube.c  Enero-2010                                              */
/*---------------------------------------------------------------------------*/
/* Realizar diferentes movimientos con Hypercube. Cada cierto tiempo se      */
/* cambia al siguiente movimiento                                            */
/*---------------------------------------------------------------------------*/
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Andres Prieto-Moreno <andres@iearobotics.com>                            */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f877.h>
#include "servos.h"
#include "timer2.h"
#include "oscillator-pyn.h"

/***********************************************************************/
/*  PARAMETROS DE LAS OSCILACIONES. MODIFICABLES POR EL USUARIO        */
/***********************************************************************/
//-- Mas documentacion en el fichero oscillator-pyn.h

//-- Velocidad de fase
#define INC 4

//--Fase inicial de los servos (en grados) (0-360)
#define FASE0 0

//-- Correspondencia entre servos virtuales y reales
//-- Cambiarlo segun el conexionado del robot y el numero de modulos usados
//-- El '0' inicial se ignora
//-- Servos virtuales:            1  2  3  4  5  6  7  8
//-- '0' significa NO-USADO
//-- Conexionado para Hypercube
__code unsigned char v[9]={0,            1, 2, 3, 4, 5, 6, 7, 8};

//-- 0: recto, 1-SW, 2- Rot. 3-Lat. SW, 

//-- Desplazamiento lateral inclinado: Av=60, Ah=60, DFv=90, DFh=90, DFvh=30
//--                  0   1     2   
__code int Av[]=  {  30, 20,   20,  };
__code int Ah[]=  {   0, 30,   30,  };
__code int DFv[]= {-130, 90, -140,  };
__code int DFh[]= {   0, 90,  -70,  };
__code int DFvh[]={   0,  0,    0,  };


/*******************************************************/
/* RUTINA DE ATENCION A LAS INTERRUPCIONES             */
/*******************************************************/
void intr(void) interrupt 0
{
  //---------------------------------------------------------------
  //-- Rutina de servicio del timer0 para actualizar las senales
  //-- de PWM
  //-----------------------------------------------------------
  if (T0IF==1)
    servos_intr();
}


//----------------------------
//- Comienzo del programa  
//----------------------------
void main(void)
{
  unsigned char m=0;
  unsigned int tiempo_ms=0;
  unsigned char TAM=sizeof(Av)/sizeof(int);  //-- Numero de movimientos diferentes
    
  //-- Inicializacion del modulo de servos
  servos_init();

  //-- Inicializar los osciladores
  oscillator_pyn_init(Av[m],Ah[m],DFv[m],DFh[m],DFvh[m],FASE0,0);

  //-- Inicializar timer 2. Configurarlo para pausas de 1ms
  timer2_init();
    
  //-- Habilitar Interrupciones
  GIE=1;

  //----------------------
  //-- Bucle principal
  //----------------------
  while (1) {

    //-- Refrescar osciladores
    oscillator_calculate(INC);

    //-- Generacion de las secuencias de movimiento
    //-- Si ha transcurrido 1ms
    if (TMR2IF==1) {
      TMR2IF=0;

      //-- Incrementar contador de tiempo
      tiempo_ms++;

      //-- Si han transcurrido 4 seg, cambiar al siguiente movimiento
      if (tiempo_ms==4000) {

        //-- Siguiente movimiento
        m = (m+1) % TAM;

        //-- Poner cronometro a 0
        tiempo_ms=0;

        //-- Recalcular osciladores para el nuevo movimiento
        oscillator_pyn_init(Av[m],Ah[m],DFv[m],DFh[m],DFvh[m],FASE0,0);
      }
      
    }    
  } 
    
}

