/*****************************************************************************/
/* test-PY8.c  Enero-2010                                                    */
/*---------------------------------------------------------------------------*/
/* Prueba de movimiento de robots del grupo cabeceo-viraje, de 8 modulos     */
/* El movimiento generado es el side-winding para Hypercube                  */
/*---------------------------------------------------------------------------*/
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Andres Prieto-Moreno <andres@iearobotics.com>                            */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f877.h>
#include "servos.h"
#include "oscillator-pyn.h"

/***********************************************************************/
/*  PARAMETROS DE LAS OSCILACIONES. MODIFICABLES POR EL USUARIO        */
/***********************************************************************/
//-- Mas documentacion en el fichero oscillator-pyn.h

//-- Velocidad de fase
#define INC 4

//-- Amplitud osciladores verticales (en grados) (0-90)
#define Av 20

//-- Amplitud osciladores horizontales (en grados) (0-90)
#define Ah 30

//-- Diferencia de fase de los osciladores verticales (en grados) (-180 a 180)
#define DFv 90

//-- Diferencia de fase de los osciladores verticales
#define DFh 90

//-- Diferencia de fase entre los osciladores verticales y horizontales
#define DFvh 0

//--Fase inicial de los servos (en grados) (0-360)
#define FASE0 0

//-- Correspondencia entre servos virtuales y reales
//-- Cambiarlo segun el conexionado del robot y el numero de modulos usados
//-- El '0' inicial se ignora
//-- Servos virtuales:            1  2  3  4  5  6  7  8
//-- '0' significa NO-USADO
//-- Conexionado para Hypercube
__code unsigned char v[9]={0,            1, 2, 3, 4, 5, 6, 7, 8};


/*******************************************************/
/* RUTINA DE ATENCION A LAS INTERRUPCIONES             */
/*******************************************************/
void intr(void) interrupt 0
{
  //---------------------------------------------------------------
  //-- Rutina de servicio del timer0 para actualizar las senales
  //-- de PWM
  //-----------------------------------------------------------
  if (T0IF==1)
    servos_intr();
}


//----------------------------
//- Comienzo del programa  
//----------------------------
void main(void)
{

  //-- Inicializacion del modulo de servos
  servos_init();

  //-- Inicializar los osciladores
  oscillator_pyn_init(Av,Ah,DFv,DFh,DFvh,FASE0,0);
    
  //-- Habilitar Interrupciones
  GIE=1;

  //----------------------
  //-- Bucle principal
  //----------------------
  while (1) {

    //-- Refrescar osciladores
    oscillator_calculate(INC);

  } 
}

