/*************************************************************************** */
/* test2.c                                                                   */
/*---------------------------------------------------------------------------*/
/* Ejemplo de pruebas de la Freeleds con la Skypic                           */
/* Conectar la Freeleds al PUERTO B de la Skypic                             */
/*---------------------------------------------------------------------------*/
/* Reproducir una secuencia en las luces de la Freeleds                      */
/*---------------------------------------------------------------------------*/
/* (c) Juan Gonzalez 2009                                                    */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

#include <pic16f876a.h>

//-- Tabla con los valores a sacar por los leds
unsigned char tabla[]={0xAA,0x55};

//-- Otras secuencias de ejemplo:

//-- Ejemplo 2: 
//-- {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80}

//-- Calculo del numero de elementos de la tabla
//-- Se pueden anadir elementos sin tener que especificar
//-- el tamano a mano
unsigned char size = sizeof(tabla)/sizeof(unsigned char);

/**********************************************/
/* Funcion de pausa                           */
/* ENTRADA: unidades de tiempo para la pausa  */
/**********************************************/
void pausa(unsigned char tiempo)
{
  unsigned char i;
  unsigned int j;
  int temp=0;

  //-- Se realizan dos bucles anidados
  for (i=0; i<tiempo; i++) {
    for (j=0; j<0x8000; j++) {
      //-- Operacion inutil, para consumir tiempo
      temp=temp+1;
    }
  }
}

void main(void)
{
  unsigned char i;

  //-- Configurar puerto B para salida
  TRISB=0x00;

  while(1) {

    //-- Recorrer todos los elementos de la tabla
    for (i=0; i<size; i++) {

      //-- Sacar el valor i por los leds
      PORTB=tabla[i];

      //-- Pausa
      pausa(2);
    }
  }

}

