//-----------------------------------------------------------------------------
//--  Concave - convex curve
//-----------------------------------------------------------------------------
//-- (c) Juan Gonzalez-Gomez (obijuan).  Jan-2013
//-- License: GPL
//------------------------------------------------------------------------------

//-- Constants
  X = 0;
  Y = 1;
  Z = 2;

//----------------------------------------------------
//-- Quater of a circle
//-- Parameters:
//--  r  - Radious
//--  th - Thickness
//----------------------------------------------------
module sector90(r, th, points = 100)
{
  
  difference() {
    cylinder(r = r, h = th, center=true, $fn=points);
  
    translate([0, -r, 0])
      cube([2*r+2, 2*r, th+2], center=true);
      
    translate([r, 0, 0])
      cube([2*r, 2*r + 2, th+2],center=true);
  }    
  
}

//---------------------------------------------------
//-- Sector of a circle
//-- Parameters:
//--   r  - Radius
//--   th - Thickness
//--   angle - Sector angle
//----------------------------------------------------
module sector(r, th, angle, points = 100)
{

  csize = [r+2, r+2, th + 2];
  
  difference() {
    sector90(r = r, th = th, points = points);
    rotate([0, 0, angle])
    translate([-csize[X]/2, csize[Y]/2, 0])
      cube(csize, center=true);
  }
}


//------------------------------------------
//--  Concave - convex curve
//--  Parameters:
//--    r1 - Convex radius
//--    r2 - Concave radius
//--    h1 - hight of the left part
//--    dx - Width of the curve
//--    th - Thickness
//--
//--    dx should be less than r1, r2
//------------------------------------------
module cc_curve(r1 = 8, r2 = 12.5, h1 = 2, dx = 12.5, th = 2)
{

  if (dx>(r1 + r2)) echo("--->WARNING dx > r1, r2");

  //-- correct dx in case it is greather than r1 + r2
  //dx = (dx>(r1 + r2)) ? r1 + r2 : dx;

  //-- Calculations
  alpha = acos( dx / (r1 + r2) );
  dy = (r1 + r2) * sin (alpha);
  
  //-- cylinder 2 coordinates
  cyl2pos = [dx, -(dy -r1 -h1),0];
  
  
  //-- Contact point: were the two curves (concave and covex) are tangents
  contactp = [ cyl2pos[X]-r2*cos(alpha), cyl2pos[Y] + r2*sin(alpha), 0];
  
  //-- body cube: A cube with the top horizontal line passing through 
  //-- the contact point
  body_size = [dx, contactp[Y], th];
  
  //-- Concave curve
  difference() {
  
    translate([body_size[X]/2, body_size[Y]/2, 0])
      cube(body_size, center=true);
      
    //-- cylinder 1  
    translate([0, r1+h1, 0])
        cylinder(r = r1, h = th+2, center=true, $fn=100);  
  }    
  
  
  //-- Calculations for trimming the bottom part of the sector
  m = max(r2, dx);
  co_size = [m+2, m+2, th+2];
  
  //-- Convex curve
  difference() {
    translate(cyl2pos)
      sector(r = r2, th = th, angle = 90 - alpha);
  
    //-- Trimming the bottom part
    translate([co_size[X]/2-1, -co_size[Y]/2, 0])
      cube(co_size, center=true);
  }
    
}


//-- Examples

cc_curve(h1 = 1, r1 = 3, r2 = 3, dx = 4.5);
//cc_curve(h1 = 2, r1 = 8, r2 = 12.5, dx = 12.5);


