//---------------------------------------------------------------
//-- Sigma technologies printable logo
//-- (c) Juan Gonzalez-Gomez (Obijuan)  juan@iearobotics.com
//-- Nov-2012
//--------------------------------------------------------------
//-- Releases under the GPL license
//--------------------------------------------------------------
use <obiscad/bcube.scad>
include <obiscad/utils.scad>
include <write/write.scad>



//-- Base parameters
letters_th = 2;
base_size = [65,50,2+letters_th];
base_bottom_th = 2;
base_cr = 2;       //-- Corner radius
base_cres=5;       //-- Corner resolution
base_wall_th = 2;  //-- Wall thickness

//-- The greek sigma letter and the T
module sigma_t() 
{
  //-- T letter
  translate([33,0,0])
    write("T",t= letters_th, h=38);

  //-- Sigma letter. Imported from the dxf file
  scale([1,1,1])
  scale([0.1,0.1,1])
    linear_extrude(height=letters_th, $fn=30)
       import(file="sigma.dxf");
}


//-- MAIN. Build the logo

//-- Base with walls
difference() {

  //-- Base cube
  bcube(base_size, cr = base_cr, cres=base_cres);

  //-- 
  translate([0,0,base_bottom_th])
    bcube(base_size - VX(2*base_wall_th) - VY(2*base_wall_th), cr=base_cr, cres=base_cres );
}

//-- Add the letters on the top of the base 
translate([-base_size[X]/2 + 4, -base_size[Y]/2+6, 0])
  color("Blue")
  sigma_t();



