//--------------------------------------------------------------
//-- Parametric IKEA table foot
//-- Derived from the table-foot
//--------------------------------------------------------------
//-- (c) Juan Gonzalez-Gomez (Obijuan) juan@iearobotics.com
//--  Nov-2012
//---------------------------------------------------------------
//-- GPL license
//---------------------------------------------------------------

use <obiscad/bcube.scad>

//-- For indexing arrays easily
X = 0;
Y = 1;
Z = 2;

//-- The leg is composed of two parts: the base and the body
//-- The base is were the drills are located

//--------------------- USER PARAMETERS. Change it! ------------------------

//-- Leg parameters
total_hi = 65;
base_side = 44;
base_hi = 4;
body_diam = 35;
drill_diam = 4.8;

//-- O-ring parameters
oring_idiam = 21;  //-- Internal diameters
oring_diam = 3;    //-- O-ring section diameter

//------------------------------------------------------------------------------

//-- Ok, let's build the foot according to the user specs ;-)

//-- Calculate the base side
base_size = [base_side, base_side, base_hi];

body_hi = total_hi;

//-- Drills coordinates
dx = base_size[X]/2 - 3 - drill_diam/2;
dy = base_size[Y]/2 - 3 - drill_diam/2;

extra = 5;

//-- Create the base
translate([0, 0, base_size[Z]/2])
difference() {
  bcube(base_size,cr=3,cres=5);

  //-- Drills
  for (i = [0:3])
    rotate([0, 0, i*90])
    translate([dx, dx, 0])
    cylinder(r = drill_diam/2, h = base_size[Z] + extra, center=true, $fn=20);
}

  
//-- The Body
translate([0, 0, total_hi/2])
difference() {
  cylinder(r=body_diam/2, h = body_hi, center=true, $fn=50);

  //-- o-ring cutout
  translate([0,0,body_hi/2-oring_diam/4])
     rotate_extrude($fn=30)
       translate([oring_idiam/2 + oring_diam/2,0,0])
         circle(r = oring_diam/2, center=true, $fn=8);
}

