//------------------------------------------------------------------------------
//  Bevel edge cube.
//  (c) Juan Gonzalez-Gomez (Obijuan), Sep-2012
//------------------------------------------------------------------------------

//-------- IMPLEMENTATION USING BOOLEAN OPERATIONS -----------------------

//------------------------------------------------------------------------------
//-- Bevel Cube main function
//-- Parameters:
//--   * Size:  Cube size
//--   * cr : Corner radius (if cr==0, a standar cube is built)
//--   * cres:  Corner resolution (in points). cres=0 means flat corners
//------------------------------------------------------------------------------
module bcube(size,cr=0,cres=0)
{
  //-- Signs for the elements on the 4 cartesian-cuadrants, starting from 0
  //-- s[i][0] is the sign of the x-coordinate cuadrant i
  //-- s[i][1] is the sign of the y-coordinate in cuadrant i
  //--  Cuadrant:       0        1         2        3
  s =                  [ [1,1], [-1,1], [-1,-1], [1,-1] ];

  //-- Get the (x,y) coorner coordinates in the 1st cuadrant
  x = size[0]/2;
  y = size[1]/2;

  //-- Exra length for clean difference operations
  extra = 2;

  //-- The final cube is composed of two parts: 
  //--  A cube without corners + the rounded corners
  union() {

  	//-- First stage: A cube without corners
	  difference() {
	    //-- Base cube
	    cube(size,center=true);
	
	    //-- Remove the 4 corners
	    //-- Repeat for the 4 cartesian cuadrant (i is the cuadrant)
	    for (i=[0:3]) {
	
	      //-- Put a 4-points base "cilinder" in every corner
	      translate( [s[i][0]*x, s[i][1]*y, 0] )
	        cylinder(r=cr, h=size[2]+extra,center=true,$fn=4);
	    }
	  }
  }

  //-- Second stage: Add the cylinders in the corners. The round
  //-- corners resolution is determine by the resolution ($fn) of 
  //-- of these cylinders 
  //-- One cylinder per cuadrant
   for (i=[0:3]) {
    translate([s[i][0]*(x-cr),s[i][1]*(y-cr), 0])
      cylinder(r=cr, h=size[2], center=true, $fn=4*(cres+1));
  }

}

//-- Examples of use of the bcube() module

//-- Standar cube
translate([-15,15,0])
bcube([20,20,10]);

//-- Beveled cube (0 point resolution)
translate([15,15,0])
  bcube([20,20,10],cr=4);

//-- Beveled cube (1 point resolution)
translate([-15,-15,0])
  bcube([20,20,10],cr=4, cres=1);

//-- Beveled cube (4 points resolution)
translate([15,-15,0])
  bcube([20,20,10],cr=4, cres=4);




