/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.uploader.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import replicatorg.uploader.FirmwareVersion;

public class FirmwareSelectionPanel
extends JPanel {
    private static final long serialVersionUID = -7960056942500494572L;
    final JLabel description = new JLabel("<html><font color=\"gray\">Select a firmware version.</font></html>");

    public FirmwareSelectionPanel(Node selectedBoard, final FirmwareSelectionListener listener) {
        this.setLayout((LayoutManager)new MigLayout("fill", "", "[grow 0][grow 100]"));
        this.add((Component)new JLabel("Select the firmware version to install:"), "growy 0,wrap");
        final JList list = new JList(new FirmwareListModel(selectedBoard));
        list.setFixedCellHeight(30);
        JScrollPane scrollPane = new JScrollPane(list);
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (list.getSelectedIndex() != -1) {
                    FirmwareVersion selectedVersion = (FirmwareVersion)list.getModel().getElementAt(list.getSelectedIndex());
                    listener.firmwareSelected(selectedVersion);
                    String descr = selectedVersion.getDescription();
                    descr = descr == null ? "<html><font color=\"gray\">No description available.</font></html>" : "<html>" + descr + "</html>";
                    FirmwareSelectionPanel.this.description.setText(descr);
                }
            }
        });
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getClickCount() == 2) {
                    listener.firmwareConfirmed();
                }
            }
        });
        list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyCode() == 10) {
                    listener.firmwareConfirmed();
                } else if (arg0.getKeyCode() == 38) {
                    list.setSelectedIndex(Math.max(list.getSelectedIndex(), 0));
                } else if (arg0.getKeyCode() == 40) {
                    list.setSelectedIndex(Math.min(list.getSelectedIndex(), list.getModel().getSize()));
                }
            }
        });
        this.add((Component)scrollPane, "width 50%");
        this.add((Component)this.description, "width 50%");
    }

    class FirmwareListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 3534926635920932686L;
        Vector<FirmwareVersion> versions = new Vector();

        public FirmwareListModel(Node selectedBoard) {
            NodeList nl = selectedBoard.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (!"firmware".equalsIgnoreCase(n.getNodeName())) continue;
                this.versions.add(new FirmwareVersion(n));
            }
        }

        public Object getElementAt(int idx) {
            return this.versions.elementAt(idx);
        }

        public int getSize() {
            return this.versions.size();
        }
    }

    static interface FirmwareSelectionListener {
        public void firmwareSelected(FirmwareVersion var1);

        public void firmwareConfirmed();
    }
}

