/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.skeinforge;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.SavingTextField;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintOMatic5D
implements SkeinforgeGenerator.SkeinforgePreference {
    private JPanel component = new JPanel((LayoutManager)new MigLayout("ins 0, fillx, hidemode 1"));
    private JCheckBox enabled;
    private String baseName = "replicatorg.skeinforge.printOMatic5D.";
    JTabbedPane printOMatic5D;

    private void addTextParameter(JComponent target, String name, String description, String defaultValue, String toolTip) {
        String fullName = this.baseName + name;
        String value = null;
        if (fullName != null) {
            value = Base.preferences.get(fullName, defaultValue);
            Base.preferences.put(fullName, value);
        }
        target.add(new JLabel(description));
        SavingTextField input = new SavingTextField(fullName, value, 10);
        target.add((Component)input, "wrap");
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    private void addDropDownParameter(JComponent target, String name, String description, Vector<String> options, String toolTip) {
        String fullName = this.baseName + name;
        String value = null;
        if (fullName != null) {
            value = Base.preferences.get(fullName, options.firstElement());
            Base.preferences.put(fullName, value);
        }
        target.add(new JLabel(description));
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(options);
        model.setSelectedItem(value);
        JComboBox<String> input = new JComboBox<String>(model);
        target.add(input, "wrap");
        input.addActionListener(new ComboListener(model, fullName));
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    private void addBooleanParameter(JComponent target, String name, String description, boolean defaultValue, String toolTip) {
        String fullName = this.baseName + name;
        boolean isSet = false;
        if (fullName != null) {
            isSet = Base.preferences.getBoolean(fullName, defaultValue);
            Base.preferences.putBoolean(fullName, isSet);
        }
        target.add(new JLabel(description));
        JCheckBox input = new JCheckBox("", isSet);
        target.add((Component)input, "wrap");
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    private double getValue(String optionName) {
        String value = Base.preferences.get(this.baseName + optionName, null);
        Base.logger.fine("Saved value for preference " + this.baseName + optionName + " is " + value);
        Double number = null;
        try {
            number = Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            Base.logger.severe("Print-O-Matic setting " + optionName + "does not contain a valid number, please correct this!");
        }
        return number;
    }

    private boolean getBooleanValue(String optionName) {
        boolean value = Base.preferences.getBoolean(this.baseName + optionName, true);
        Base.logger.fine("Saved value for preference " + this.baseName + optionName + " is " + value);
        return value;
    }

    private String getStringValue(String optionName) {
        String value = Base.preferences.get(this.baseName + optionName, null);
        Base.logger.fine("Saved value for preference " + this.baseName + optionName + " is " + value);
        return value;
    }

    private double getScalingFactor() {
        String value = Base.preferences.get(this.baseName + "materialType", null);
        double scalingFactor = 1.0;
        if (value.equals("ABS")) {
            scalingFactor = 0.85;
        } else if (value.equals("PLA")) {
            scalingFactor = 1.0;
        } else {
            Base.logger.severe("Couldn't determine scaling factor for material " + value + ", defaulting to 1");
        }
        return scalingFactor;
    }

    public PrintOMatic5D() {
        final String enabledName = this.baseName + "enabled";
        this.enabled = new JCheckBox("Use Print-O-Matic (stepper extruders only)", Base.preferences.getBoolean(enabledName, false));
        this.enabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (enabledName != null) {
                    Base.preferences.putBoolean(enabledName, PrintOMatic5D.this.enabled.isSelected());
                    PrintOMatic5D.this.printOMatic5D.setVisible(PrintOMatic5D.this.enabled.isSelected());
                    PrintOMatic5D.this.printOMatic5D.invalidate();
                    Window w = SwingUtilities.getWindowAncestor(PrintOMatic5D.this.printOMatic5D);
                    w.pack();
                }
            }
        });
        this.component.add((Component)this.enabled, "wrap, spanx");
        this.printOMatic5D = new JTabbedPane();
        JPanel printPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        JPanel materialPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        JPanel supportPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.addTextParameter(printPanel, "infillPercent", "Object infill (%)", "30", "0= hollow object, 100=solid object");
        this.addTextParameter(printPanel, "desiredLayerHeight", "Layer Height (mm)", "0.35", "Set the desired layer height");
        this.addTextParameter(printPanel, "desiredPathWidth", "Path Width (mm)", "0.5", "Set the desired layer width");
        this.addTextParameter(printPanel, "numberOfShells", "Number of shells:", "1", "Number of shells to add to the perimeter of an object. Set this to 0 if you are printing a model with thin features.");
        this.addTextParameter(printPanel, "desiredFeedrate", "Feedrate (mm/s)", "30", "slow: 0-20, default: 30, Fast: 40+");
        Vector<String> materialTypes = new Vector<String>();
        materialTypes.add("ABS");
        materialTypes.add("PLA");
        this.addDropDownParameter(materialPanel, "materialType", "Material type:", materialTypes, "Select the type of plastic to use during print");
        this.addTextParameter(materialPanel, "filamentDiameter", "Filament Diameter (mm)", "2.94", "measure feedstock");
        this.addTextParameter(materialPanel, "packingDensity", "Final Volume (%)", "85", "Between 85 and 100.");
        this.addBooleanParameter(supportPanel, "useRaft", "Use raft", true, "If this option is checked, skeinforge will lay down a rectangular 'raft' of plastic before starting the build.  Rafts increase the build size slightly, so you should avoid using a raft if your build goes to the edge of the platform.");
        Vector<String> supportTypes = new Vector<String>();
        supportTypes.add("None");
        supportTypes.add("Exterior support");
        supportTypes.add("Full support");
        this.addDropDownParameter(supportPanel, "choiceSupport", "Use support material:", supportTypes, "If this option is selected, skeinforge will attempt to support large overhangs by laying down a support structure that you can later remove.");
        this.printOMatic5D.addTab("Settings", printPanel);
        this.printOMatic5D.addTab("Plastic", materialPanel);
        this.printOMatic5D.addTab("Support", supportPanel);
        this.component.add((Component)this.printOMatic5D, "spanx");
        this.printOMatic5D.setVisible(this.enabled.isSelected());
    }

    @Override
    public JComponent getUI() {
        return this.component;
    }

    @Override
    public String valueSanityCheck() {
        if (this.enabled.isSelected()) {
            // empty if block
        }
        return null;
    }

    @Override
    public List<SkeinforgeGenerator.SkeinforgeOption> getOptions() {
        LinkedList<SkeinforgeGenerator.SkeinforgeOption> options = new LinkedList<SkeinforgeGenerator.SkeinforgeOption>();
        if (this.enabled.isSelected()) {
            double perimeterWidthOverThickness;
            double infillRatio = this.getValue("infillPercent") / 100.0;
            double filamentDiameter = this.getValue("filamentDiameter");
            double packingDensity = this.getValue("packingDensity") / 100.0;
            double infillWidthOverThickness = perimeterWidthOverThickness = this.getValue("desiredPathWidth") / this.getValue("desiredLayerHeight");
            double feedRate = this.getValue("desiredFeedrate");
            double layerHeight = this.getValue("desiredLayerHeight");
            double extraShellsOnAlternatingSolidLayer = this.getValue("numberOfShells");
            double extraShellsOnBase = this.getValue("numberOfShells");
            double extraShellsOnSparseLayer = this.getValue("numberOfShells");
            boolean useRaft = this.getBooleanValue("useRaft");
            String supportType = this.getStringValue("choiceSupport");
            Base.logger.fine("Print-O-Matic settings:\n infillRatio=" + infillRatio + "\n filamentDiameter=" + filamentDiameter + "\n packingDensity=" + packingDensity + "\n perimeterWidthOverThickness=" + perimeterWidthOverThickness + "\n infillWidthOverThickness=" + infillWidthOverThickness + "\n feedRate=" + feedRate + "\n layerHeight=" + layerHeight + "\n extraShellsOnAlternatingSolidLayer=" + extraShellsOnAlternatingSolidLayer + "\n extraShellsOnBase=" + extraShellsOnBase + "\n extraShellsOnSparseLayer=" + extraShellsOnSparseLayer + "\n useRaft=" + useRaft + "\n supportType=" + supportType);
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Infill Solidity (ratio):", Double.toString(infillRatio)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("speed.csv", "Feed Rate (mm/s):", Double.toString(feedRate)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("speed.csv", "Flow Rate Setting (float):", Double.toString(feedRate)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("dimension.csv", "Filament Diameter (mm):", Double.toString(filamentDiameter)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("dimension.csv", "Filament Packing Density (ratio):", Double.toString(packingDensity)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("carve.csv", "Perimeter Width over Thickness (ratio):", Double.toString(perimeterWidthOverThickness)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Infill Width over Thickness (ratio):", Double.toString(infillWidthOverThickness)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("carve.csv", "Layer Thickness (mm):", Double.toString(layerHeight)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Extra Shells on Alternating Solid Layer (layers):", Double.toString(extraShellsOnAlternatingSolidLayer)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Extra Shells on Base (layers):", Double.toString(extraShellsOnBase)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Extra Shells on Sparse Layer (layers):", Double.toString(extraShellsOnSparseLayer)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Add Raft, Elevate Nozzle, Orbit:", useRaft ? "true" : "false"));
            if (supportType.equals("None")) {
                options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "true"));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
            } else if (supportType.equals("Exterior support")) {
                options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "true"));
            } else if (supportType.equals("Full support")) {
                options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "true"));
                options.add(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
            }
        }
        return options;
    }

    private class ComboListener
    implements ActionListener {
        final String name;
        final DefaultComboBoxModel input;

        public ComboListener(DefaultComboBoxModel input, String name) {
            this.input = input;
            this.name = name;
        }

        public void actionPerformed(ActionEvent arg0) {
            String value = this.input.getSelectedItem().toString();
            if (this.name != null) {
                Base.logger.fine("here: " + this.name + "=" + value);
                Base.preferences.put(this.name, value);
            }
        }
    }
}

