/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.skeinforge;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;

class ConfigurationDialog
extends JDialog {
    final boolean postProcessToolheadIndex = true;
    final String profilePref = "replicatorg.skeinforge.profilePref";
    JButton generateButton = new JButton("Generate Gcode");
    JButton cancelButton = new JButton("Cancel");
    private SkeinforgeGenerator parentGenerator = null;
    private List<SkeinforgeGenerator.Profile> profiles = null;
    JPanel profilePanel = new JPanel();
    final JComboBox prefPulldown = new JComboBox();

    private void loadList(JComboBox comboBox) {
        comboBox.removeAllItems();
        this.profiles = this.parentGenerator.getProfiles();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        int i = 0;
        int foundLastProfile = -1;
        for (SkeinforgeGenerator.Profile p : this.profiles) {
            model.addElement(p.toString());
            if (p.toString().equals(Base.preferences.get("lastGeneratorProfileSelected", "---"))) {
                Base.logger.fine("Selecting last used element: " + p);
                foundLastProfile = i;
            }
            ++i;
        }
        comboBox.setModel(model);
        if (foundLastProfile != -1) {
            comboBox.setSelectedIndex(foundLastProfile);
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.parentGenerator = null;
            this.profiles = null;
        }
    }

    private SkeinforgeGenerator.Profile getListedProfile(int idx) {
        return this.profiles.get(idx);
    }

    public ConfigurationDialog(Frame parent, SkeinforgeGenerator parentGeneratorIn) {
        super(parent, true);
        this.parentGenerator = parentGeneratorIn;
        this.setTitle("GCode Generator");
        this.setLayout((LayoutManager)new MigLayout("aligny, top, ins 5, fill"));
        this.add((Component)new JLabel("Base Profile:"), "split 2");
        this.prefPulldown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ConfigurationDialog.this.generateButton.setEnabled(true);
                ConfigurationDialog.this.generateButton.requestFocusInWindow();
                ConfigurationDialog.this.generateButton.setFocusPainted(true);
            }
        });
        this.loadList(this.prefPulldown);
        this.add((Component)this.prefPulldown, "wrap, growx");
        for (SkeinforgeGenerator.SkeinforgePreference preference : this.parentGenerator.preferences) {
            this.add((Component)preference.getUI(), "wrap");
        }
        final JCheckBox autoGen = new JCheckBox("Automatically generate when building.");
        autoGen.setToolTipText("When building from the model view with this checked GCode will automatically be generated, bypassing this dialog.");
        this.add((Component)autoGen, "wrap");
        autoGen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Base.preferences.putBoolean("build.autoGenerateGcode", autoGen.isSelected());
            }
        });
        autoGen.setSelected(Base.preferences.getBoolean("build.autoGenerateGcode", false));
        this.add((Component)this.generateButton, "tag ok, split 2");
        this.add((Component)this.cancelButton, "tag cancel");
        this.generateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.configSuccess = ConfigurationDialog.this.configureGenerator();
                ConfigurationDialog.this.setVisible(!((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.configSuccess);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.configSuccess = false;
                ConfigurationDialog.this.setVisible(false);
            }
        });
    }

    protected boolean configureGenerator() {
        if (!this.parentGenerator.runSanityChecks()) {
            return false;
        }
        int idx = this.prefPulldown.getSelectedIndex();
        if (idx == -1) {
            return false;
        }
        SkeinforgeGenerator.Profile p = this.getListedProfile(idx);
        Base.preferences.put("lastGeneratorProfileSelected", p.toString());
        this.parentGenerator.profile = p.getFullPath();
        SkeinforgeGenerator.setSelectedProfile(p.toString());
        return true;
    }
}

