/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin;

import java.util.Iterator;
import java.util.Vector;
import replicatorg.app.GCode;
import replicatorg.model.GCodeSource;
import replicatorg.plugin.MCodePlugin;
import replicatorg.plugin.PluginEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginEngine
implements GCodeSource {
    GCodeSource parent = null;
    Vector<PluginEntry> plugins;

    void setParentSource(GCodeSource parent) {
        this.parent = parent;
    }

    void setPlugins(Vector<PluginEntry> plugins) {
        this.plugins = plugins;
    }

    @Override
    public int getLineCount() {
        return this.parent.getLineCount();
    }

    private void processLine(String line) {
        GCode mcode = new GCode(line);
        if (mcode.hasCode('M')) {
            double code = mcode.getCodeValue('M');
            for (PluginEntry plugin : this.plugins) {
                int[] codes;
                if (!(plugin instanceof MCodePlugin)) continue;
                MCodePlugin mcp = (MCodePlugin)((Object)plugin);
                for (int acceptedCode : codes = mcp.getAcceptedMCodes()) {
                    if (code != (double)acceptedCode) continue;
                    mcp.processMCode(mcode);
                }
            }
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new GCodeIterator(this.parent.iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GCodeIterator
    implements Iterator<String> {
        private Iterator<String> parent;

        public GCodeIterator(Iterator<String> parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            return this.parent.hasNext();
        }

        @Override
        public String next() {
            String next = this.parent.next();
            PluginEngine.this.processLine(next);
            return next;
        }

        @Override
        public void remove() {
            this.parent.remove();
        }
    }
}

