/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.model;

import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.undo.UndoManager;
import replicatorg.model.Build;

public abstract class BuildElement {
    protected UndoManager undo = new UndoManager();
    private List<Listener> listeners = new LinkedList<Listener>();
    protected Build parent = null;
    private boolean modified = false;

    public UndoManager getUndoManager() {
        return this.undo;
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    protected void emitUpdate() {
        for (Listener l : this.listeners) {
            l.buildElementUpdate(this);
        }
    }

    public abstract Type getType();

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        if (this.modified == modified) {
            return;
        }
        this.modified = modified;
        this.emitUpdate();
    }

    abstract void writeToStream(OutputStream var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        MODEL("model"),
        GCODE("gcode");

        private String displayString;

        private Type(String displayString) {
            this.displayString = displayString;
        }

        public String getDisplayString() {
            return this.displayString;
        }
    }

    public static interface Listener {
        public void buildElementUpdate(BuildElement var1);
    }
}

