/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine.builder;

import java.util.logging.Level;
import replicatorg.app.Base;
import replicatorg.drivers.Driver;
import replicatorg.drivers.SDCardCapture;
import replicatorg.drivers.SimulationDriver;
import replicatorg.machine.Machine;
import replicatorg.machine.builder.Direct;
import replicatorg.machine.builder.MachineBuilder;
import replicatorg.model.GCodeSource;

public class ToRemoteFile
implements MachineBuilder {
    Direct directBuilder;
    SDCardCapture sdcc;
    public boolean setupFailed = true;

    public ToRemoteFile(Driver driver, SimulationDriver simulator, GCodeSource source, String remoteName) {
        if (!(driver instanceof SDCardCapture)) {
            Base.logger.log(Level.WARNING, "Build to remote file requires a driver with SDCardCapture!");
            return;
        }
        this.sdcc = (SDCardCapture)((Object)driver);
        if (SDCardCapture.ResponseCode.processSDResponse(this.sdcc.beginCapture(remoteName))) {
            this.directBuilder = new Direct(driver, simulator, source);
            this.setupFailed = false;
        }
    }

    public boolean finished() {
        if (this.setupFailed) {
            return true;
        }
        if (!this.directBuilder.finished()) {
            return false;
        }
        int totalBytes = this.sdcc.endCapture();
        Base.logger.info("Captured bytes: " + Integer.toString(totalBytes));
        return true;
    }

    public void runNext() {
        if (this.directBuilder != null) {
            this.directBuilder.runNext();
        }
    }

    public int getLinesTotal() {
        if (this.directBuilder == null) {
            return -1;
        }
        return this.directBuilder.getLinesTotal();
    }

    public int getLinesProcessed() {
        if (this.directBuilder == null) {
            return -1;
        }
        return this.directBuilder.getLinesProcessed();
    }

    public boolean isInteractive() {
        return false;
    }

    public Machine.JobTarget getTarget() {
        return Machine.JobTarget.REMOTE_FILE;
    }
}

