/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine;

import java.util.LinkedList;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.GCode;
import replicatorg.app.GCodeEnumeration;
import replicatorg.app.GCodeParser;
import replicatorg.drivers.Driver;
import replicatorg.drivers.DriverQueryInterface;
import replicatorg.drivers.EstimationDriver;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.SimulationDriver;
import replicatorg.drivers.StopException;
import replicatorg.drivers.commands.DriverCommand;
import replicatorg.machine.MachineCallbackHandler;
import replicatorg.machine.MachineCommand;
import replicatorg.machine.MachineInterface;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineState;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineThread;
import replicatorg.machine.MachineToolStatusEvent;
import replicatorg.machine.model.MachineModel;
import replicatorg.machine.model.ToolModel;
import replicatorg.model.GCodeSource;
import replicatorg.util.Point5d;

public class Machine
implements MachineInterface {
    MachineThread machineThread;
    final MachineCallbackHandler callbackHandler;
    protected Node machineNode;
    private String message;
    private long numWarnings;
    private long numErrors;

    public MachineState getMachineState() {
        return this.machineThread.getMachineState();
    }

    public String getMachineName() {
        return this.machineThread.getMachineName();
    }

    public Machine(Node mNode, MachineCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        this.machineNode = mNode;
        this.machineThread = new MachineThread(this, mNode);
        this.machineThread.start();
    }

    public boolean buildRemote(String remoteName) {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.BUILD_REMOTE, null, remoteName));
        return true;
    }

    public boolean buildDirect(GCodeSource source) {
        int proceed;
        Base.logger.info("Estimating build time and scanning code for errors...");
        this.numWarnings = 0L;
        this.numErrors = 0L;
        this.message = null;
        this.estimate(source);
        if (this.numErrors > 0L) {
            JOptionPane.showConfirmDialog(null, new Object[]{"The pre-run check has found some problematic GCode.", "This may be a result of trying to run code on a machine other than the one it's\nintended for (i.e. running dual headed GCode on a single headed machine).", "This message can be turned off from the preferences menu.", "\nError 1 of " + this.numErrors + " (see console for more): " + this.message, "\nErrors must be fixed before this build can be safely run."}, "GCode Check: Error", -1, 0);
            return false;
        }
        if (this.numWarnings > 0L && (proceed = JOptionPane.showConfirmDialog(null, new Object[]{"The pre-run check has found some potentially problematic GCode.", "This may be a result of trying to run code on a machine other than the one it's\nintended for (i.e. running dual headed GCode on a single headed machine).", "This message can be turned off from the preferences menu.", "\nWarning 1 of " + this.numWarnings + " (see console for more): " + this.message, "\nWould you like to proceed with the build anyway?"}, "GCode Check: Warning", 0, 2)) == 1) {
            return false;
        }
        Base.logger.info("Beginning build.");
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.BUILD_DIRECT, source, null));
        return true;
    }

    public void simulate(GCodeSource source) {
        Base.logger.info("Estimating build time...");
        this.estimate(source);
        Base.logger.info("Beginning simulation.");
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.SIMULATE, source, null));
    }

    public void estimate(GCodeSource source) {
        if (source == null) {
            return;
        }
        EstimationDriver estimator = new EstimationDriver();
        estimator.setMachine(this.machineThread.getModel());
        boolean safetyChecks = Base.preferences.getBoolean("build.runSafetyChecks", true);
        int nToolheads = this.machineThread.getModel().getTools().size();
        Point5d maxRates = this.machineThread.getModel().getMaximumFeedrates();
        LinkedList<DriverCommand> estimatorQueue = new LinkedList<DriverCommand>();
        GCodeParser estimatorParser = new GCodeParser();
        estimatorParser.init(estimator);
        for (String line : source) {
            estimatorParser.parse(line, estimatorQueue);
            if (safetyChecks) {
                String s;
                GCode gcLine = new GCode(line);
                String mainCode = gcLine.getCommand().split(" ")[0];
                if (!"".equals(mainCode) && GCodeEnumeration.getGCode(mainCode) == null) {
                    s = "Unsupported GCode!\n" + line + " uses a code that ReplicatorG doesn't recognize.";
                    if (this.message == null) {
                        this.message = s + '\n';
                    }
                    Base.logger.log(Level.SEVERE, s);
                    ++this.numErrors;
                }
                if (gcLine.getCodeValue('T') > (double)(nToolheads - 1) && gcLine.getCodeValue('M') != 109.0 && gcLine.getCodeValue('M') != 106.0 && gcLine.getCodeValue('M') != 107.0) {
                    s = "Too Many Toolheads!\n" + line + " makes reference to a non-existent toolhead.";
                    if (this.message == null) {
                        this.message = s + '\n';
                    }
                    Base.logger.log(Level.SEVERE, s);
                    ++this.numErrors;
                }
                if (gcLine.hasCode('F')) {
                    double fVal = gcLine.getCodeValue('F');
                    if (gcLine.hasCode('X') && fVal > maxRates.x() || gcLine.hasCode('Y') && fVal > maxRates.y() || gcLine.hasCode('A') && fVal > maxRates.a() || gcLine.hasCode('B') && fVal > maxRates.b()) {
                        s = "You're moving too fast!\n" + line + " Tries to turn an axis faster than its max rate.";
                        if (this.message == null) {
                            this.message = s + '\n';
                        }
                        Base.logger.log(Level.WARNING, s);
                        ++this.numWarnings;
                    }
                }
            }
            for (DriverCommand command : estimatorQueue) {
                try {
                    command.run(estimator);
                }
                catch (RetryException r) {
                }
                catch (StopException e) {}
            }
            estimatorQueue.clear();
        }
        this.machineThread.setEstimatedBuildTime(estimator.getBuildTime());
        Base.logger.info("Estimated build time is: " + EstimationDriver.getBuildTimeString(estimator.getBuildTime()));
    }

    public DriverQueryInterface getDriverQueryInterface() {
        return (DriverQueryInterface)((Object)this.machineThread.getDriver());
    }

    public Driver getDriver() {
        return this.machineThread.getDriver();
    }

    public SimulationDriver getSimulatorDriver() {
        return this.machineThread.getSimulator();
    }

    public MachineModel getModel() {
        return this.machineThread.getModel();
    }

    public void stopMotion() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.STOP_MOTION, null, null));
    }

    public void stopAll() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.STOP_ALL, null, null));
    }

    public synchronized boolean isConnected() {
        return this.machineThread.isConnected();
    }

    public void pause() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.PAUSE, null, null));
    }

    public void upload(GCodeSource source, String remoteName) {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.BUILD_TO_REMOTE_FILE, source, remoteName));
    }

    public void buildToFile(GCodeSource source, String path) {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.BUILD_TO_FILE, source, path));
    }

    public void unpause() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.UNPAUSE, null, null));
    }

    public void reset() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.RESET, null, null));
    }

    public void connect(String portName) {
        if (!this.machineThread.isAlive()) {
            this.machineThread = new MachineThread(this, this.machineNode);
            this.machineThread.start();
        }
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.CONNECT, null, portName));
    }

    public synchronized void disconnect() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.DISCONNECT, null, null));
    }

    public synchronized boolean isPaused() {
        return this.getMachineState().isPaused();
    }

    public void runCommand(DriverCommand command) {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.RUN_COMMAND, command));
    }

    public void dispose() {
        if (this.machineThread != null) {
            this.machineThread.scheduleRequest(new MachineCommand(RequestType.SHUTDOWN, null, null));
            try {
                this.machineThread.join(5000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void emitStateChange(MachineState current, String message) {
        MachineStateChangeEvent e = new MachineStateChangeEvent(this, current, message);
        this.callbackHandler.schedule(e);
    }

    protected void emitProgress(MachineProgressEvent progress) {
        this.callbackHandler.schedule(progress);
    }

    protected void emitToolStatus(ToolModel tool) {
        MachineToolStatusEvent e = new MachineToolStatusEvent(this, tool);
        this.callbackHandler.schedule(e);
    }

    public int getLinesProcessed() {
        return this.machineThread.getLinesProcessed();
    }

    public boolean isSimulating() {
        return this.machineThread.isSimulating();
    }

    public boolean isInteractiveTarget() {
        return this.machineThread.isInteractiveTarget();
    }

    public JobTarget getTarget() {
        return this.machineThread.getTarget();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JobTarget {
        NONE,
        SIMULATOR,
        MACHINE,
        REMOTE_FILE,
        FILE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestType {
        CONNECT,
        DISCONNECT,
        DISCONNECT_REMOTE_BUILD,
        RESET,
        SIMULATE,
        BUILD_DIRECT,
        BUILD_TO_FILE,
        BUILD_TO_REMOTE_FILE,
        BUILD_REMOTE,
        PAUSE,
        UNPAUSE,
        STOP_MOTION,
        STOP_ALL,
        RUN_COMMAND,
        SHUTDOWN;

    }
}

