/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.dualstrusion;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import replicatorg.app.Base;
import replicatorg.dualstrusion.Layer;
import replicatorg.dualstrusion.Toolheads;
import replicatorg.machine.model.WipeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerHelper {
    private Toolheads currentToolhead;
    private ArrayList<Layer> primaryLayers;
    private ArrayList<Layer> secondaryLayers;
    private float tolerance = 0.01f;
    private boolean mergeSupport;
    private boolean useWipes;

    public LayerHelper(ArrayList<String> primary, ArrayList<String> secondary, boolean useWipes, boolean mergeSupport) {
        this.primaryLayers = this.readLayers(primary);
        this.secondaryLayers = this.readLayers(secondary);
        this.useWipes = useWipes;
        this.mergeSupport = mergeSupport;
        this.currentToolhead = Toolheads.PRIMARY;
    }

    public Layer getByHeight(float height, ArrayList<Layer> searchme) {
        for (Layer l : searchme) {
            if (!(Math.abs(l.getHeight() - height) < this.tolerance / 2.0f)) continue;
            return l;
        }
        return null;
    }

    private void seeLayerHeights(ArrayList<Layer> a) {
        for (Layer layer : a) {
        }
    }

    public ArrayList<String> toolChange(Toolheads destinationTool, float LayerHeight) {
        this.currentToolhead = destinationTool;
        return this.completeToolChange(destinationTool, LayerHeight);
    }

    public ArrayList<String> toolChange(Toolheads destinationTool, Layer a) {
        this.currentToolhead = destinationTool;
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.addAll(this.completeToolChange(destinationTool, a.getHeight()));
        cmds.add(this.getFirstMove(a.getCommands()));
        return cmds;
    }

    public ArrayList<String> mergeLayers() {
        ArrayList<String> merged = new ArrayList<String>();
        float maxHeight1 = this.primaryLayers.get(this.primaryLayers.size() - 1).getHeight();
        float maxHeight0 = this.secondaryLayers.get(this.secondaryLayers.size() - 1).getHeight();
        float maxHeight = maxHeight0 < maxHeight1 ? maxHeight1 : maxHeight0;
        merged.addAll(this.toolChange(Toolheads.PRIMARY, 0.6f));
        float i = 0.0f;
        while ((double)i < (double)maxHeight - 0.008) {
            Layer a = this.getByHeight(i, this.primaryLayers);
            Layer b = this.getByHeight(i, this.secondaryLayers);
            if (a != null || b != null) {
                if (this.mergeSupport) {
                    System.out.println("mergeSupport is: ON");
                    merged.addAll(this.toolChange(Toolheads.PRIMARY, i));
                }
                if (a != null && b != null) {
                    merged.addAll(this.mergeLayer(a, b));
                } else if (a != null) {
                    merged.addAll(this.parseLayer(a, Toolheads.PRIMARY));
                } else if (b != null) {
                    merged.addAll(this.parseLayer(b, Toolheads.SECONDARY));
                }
            }
            i += this.tolerance;
        }
        return merged;
    }

    private String getFirstMove(ArrayList<String> cmds) {
        for (String s : cmds) {
            if (!s.matches("G1.*")) continue;
            if (s.contains("F")) {
                int lastf = s.lastIndexOf("F");
                s = s.substring(0, lastf);
            }
            return s + " F1700.0 (added by getFirstMove)";
        }
        return " ";
    }

    private ArrayList<String> parseLayer(Layer a, Toolheads destTool) {
        ArrayList<String> completeLayer = new ArrayList<String>();
        if (destTool == Toolheads.PRIMARY) {
            if (this.currentToolhead == Toolheads.PRIMARY) {
                completeLayer.addAll(a.getCommands());
            } else if (this.currentToolhead == Toolheads.SECONDARY) {
                completeLayer.addAll(this.toolChange(Toolheads.PRIMARY, a));
                completeLayer.addAll(a.getCommands());
            }
        } else if (destTool == Toolheads.SECONDARY) {
            if (this.currentToolhead == Toolheads.SECONDARY) {
                completeLayer.addAll(a.getCommands());
            } else if (this.currentToolhead == Toolheads.PRIMARY) {
                completeLayer.addAll(this.toolChange(Toolheads.SECONDARY, a));
                completeLayer.addAll(a.getCommands());
            }
        }
        return completeLayer;
    }

    public ArrayList<Layer> readLayers(ArrayList<String> readThis) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        block2: for (int i = 0; i < readThis.size() - 2; ++i) {
            if (!readThis.get(i).matches("\\(\\<layer\\>.*\\)")) continue;
            float layerHeight = 0.0f;
            try {
                layerHeight = Float.parseFloat(readThis.get(i).split(" ")[1]);
            }
            catch (NumberFormatException e) {
                Base.logger.log(Level.SEVERE, "one of your layer heights was unparseable, please check and make sure all of them are in the format (<layer> 0.00)");
            }
            int a = i + 1;
            while (true) {
                if (readThis.get(a).equalsIgnoreCase("(</layer>)")) {
                    ArrayList<String> tempList = new ArrayList<String>(readThis.subList(i, a + 1));
                    result.add(new Layer(layerHeight, tempList));
                    continue block2;
                }
                ++a;
            }
        }
        return result;
    }

    private ArrayList<String> mergeLayer(Layer a, Layer b) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat nf = new DecimalFormat();
        nf.setDecimalFormatSymbols(dfs);
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("(<layer> " + nf.format(a.getHeight()) + " )");
        if (this.currentToolhead == Toolheads.PRIMARY) {
            cmds.addAll(a.getCommandsWithoutLayerTag());
            cmds.addAll(this.toolChange(Toolheads.SECONDARY, a));
            cmds.addAll(b.getCommandsWithoutLayerTag());
        } else if (this.currentToolhead == Toolheads.SECONDARY) {
            cmds.addAll(b.getCommandsWithoutLayerTag());
            cmds.addAll(this.toolChange(Toolheads.PRIMARY, b));
            cmds.addAll(a.getCommandsWithoutLayerTag());
        }
        cmds.add("(</layer>)");
        return cmds;
    }

    public ArrayList<String> wipe(int currentToolnum, int nextToolnum, float layer_height) {
        WipeModel tool0Wipes = Base.getMachineLoader().getMachine().getModel().getWipeByIndex(0);
        WipeModel tool1Wipes = Base.getMachineLoader().getMachine().getModel().getWipeByIndex(1);
        if (tool0Wipes == null || tool1Wipes == null) {
            String error = "Could not find wipes for the current machine," + Base.getMachineLoader().getMachine().getModel().toString() + "please select a dualstrusion machine in the drivers menu.";
            JOptionPane.showConfirmDialog(null, error, "Could not prepare Dualstrusion!", -1, 0);
        }
        ArrayList<String> result = new ArrayList<String>();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat nf = new DecimalFormat();
        nf.setDecimalFormatSymbols(dfs);
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(2);
        nf.setGroupingUsed(false);
        String[] purge_x = new String[]{nf.format(tool0Wipes.getX1()), nf.format(tool1Wipes.getX1())};
        String[] purge_y = new String[]{nf.format(tool0Wipes.getY1()), nf.format(tool1Wipes.getY1())};
        String[] purge_x_offset = new String[]{nf.format(tool0Wipes.getX2()), nf.format(tool1Wipes.getX2())};
        String[] purge_y_offset = new String[]{nf.format(tool0Wipes.getY2()), nf.format(tool1Wipes.getY2())};
        String[] purge_z = new String[]{nf.format(tool0Wipes.getZ1()), nf.format(tool1Wipes.getZ1())};
        String[] purge_z_offset = new String[]{nf.format(tool0Wipes.getZ2()), nf.format(tool1Wipes.getZ2())};
        String[] wait_time = new String[]{nf.format(tool0Wipes.getWait()), nf.format(tool1Wipes.getWait())};
        String[] feedrate = new String[]{"3000.0", "3000.0"};
        String[] flowrate = new String[]{nf.format(tool0Wipes.getPurgeRPM()), nf.format(tool1Wipes.getPurgeRPM())};
        String[] full_reversal_flowrate = new String[]{nf.format(tool0Wipes.getReverseRPM()), nf.format(tool1Wipes.getReverseRPM())};
        int[] purge_duration = new int[]{tool0Wipes.getPurgeDuration(), tool1Wipes.getPurgeDuration()};
        int[] full_reversal_duration = new int[]{tool0Wipes.getReverseDuration(), tool1Wipes.getReverseDuration()};
        result.add("M108 R" + full_reversal_flowrate[nextToolnum]);
        result.add("M102");
        result.add("G04 P" + full_reversal_duration[nextToolnum]);
        result.add("M103");
        result.add("M108 R" + flowrate[nextToolnum]);
        if (this.useWipes) {
            result.add("G53");
            if (layer_height > Float.parseFloat(purge_z[nextToolnum])) {
                result.add("G1 X0 Y" + purge_y[nextToolnum] + " F" + feedrate[nextToolnum]);
                result.add("G1 X" + purge_x[nextToolnum] + " Y" + purge_y[nextToolnum] + " F" + feedrate[nextToolnum]);
                result.add("G1 Z" + purge_z[nextToolnum] + " F" + feedrate[nextToolnum]);
            } else {
                result.add("G1 X0 Y" + purge_y[nextToolnum] + " F" + feedrate[nextToolnum]);
                result.add("G1 X" + purge_x[nextToolnum] + " Y" + purge_y[nextToolnum] + " Z" + purge_z[nextToolnum] + " F" + feedrate[nextToolnum]);
            }
            result.add("M103 T" + nextToolnum);
            result.add("G1 X" + purge_x[nextToolnum] + " Y" + purge_y[nextToolnum] + " Z" + purge_z[nextToolnum] + " F" + feedrate[nextToolnum]);
            result.add("M101");
            result.add("G04 P" + purge_duration[nextToolnum]);
            result.add("M102");
            result.add("M103");
            result.add("M108 R" + flowrate[nextToolnum]);
            result.add("G04 P" + wait_time[nextToolnum]);
            result.add("G1 X" + purge_x_offset[nextToolnum] + " Y" + purge_y[nextToolnum] + " Z" + purge_z[nextToolnum] + " F" + feedrate[nextToolnum]);
            result.add("G1 X" + purge_x_offset[nextToolnum] + " Y" + purge_y_offset[nextToolnum] + " Z" + purge_z[nextToolnum] + " F" + feedrate[nextToolnum]);
            result.add("G1 X" + purge_x[currentToolnum] + " Y" + purge_y[currentToolnum] + " Z" + purge_z[currentToolnum] + " F" + feedrate[currentToolnum]);
            result.add("G1 X" + purge_x_offset[currentToolnum] + " Y" + purge_y[currentToolnum] + " Z" + purge_z[currentToolnum] + " F" + feedrate[currentToolnum]);
            result.add("G1 X" + purge_x_offset[currentToolnum] + " Y" + purge_y_offset[currentToolnum] + " Z" + purge_z_offset[currentToolnum] + " F" + feedrate[currentToolnum]);
            result.add("G1 X0 Y" + purge_y[nextToolnum] + " Z" + purge_z[nextToolnum] + " F" + feedrate[nextToolnum]);
        }
        return result;
    }

    public ArrayList<String> completeToolChange(Toolheads nextTool, float layer_height) {
        ArrayList<String> targetCode = new ArrayList<String>();
        Toolheads currentTool = null;
        if (nextTool == Toolheads.PRIMARY) {
            currentTool = Toolheads.SECONDARY;
        } else if (nextTool == Toolheads.SECONDARY) {
            currentTool = Toolheads.PRIMARY;
        }
        int nextToolnum = nextTool.number;
        int currentToolnum = currentTool.number;
        float hop_height = 7.0f;
        targetCode.add("(<toolchange>)");
        float purge_z = 6.5f;
        targetCode.add("M103");
        targetCode.add("G1 Z" + (layer_height + hop_height));
        targetCode.addAll(this.wipe(currentToolnum, nextToolnum, layer_height));
        targetCode.add("M103");
        targetCode.add("G5" + (5 - nextToolnum));
        float h = layer_height + hop_height;
        targetCode.add("G1 Z" + h + " F2000");
        targetCode.add("(</toolchange>)");
        return targetCode;
    }
}

