/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.dualstrusion;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import replicatorg.app.Base;
import replicatorg.dualstrusion.LayerHelper;
import replicatorg.dualstrusion.Toolheads;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DualStrusionWorker {
    private static float yDanger = 80.0f;

    public static void stripEndlines(ArrayList<String> gcode) {
        for (String s : gcode) {
            s = s.replaceAll("\n", "");
            s = s.replaceAll("\r", "");
            String string = s.trim();
        }
    }

    public static String pullComment(String line, boolean prefixSpace) {
        Pattern commentMatch = Pattern.compile("(.*?)(\\(.*\\))");
        Matcher m = commentMatch.matcher(line);
        if (m.matches()) {
            if (prefixSpace) {
                return " " + m.group(2);
            }
            return m.group(2);
        }
        return "";
    }

    private static String getTemperatureCommand(ArrayList<String> gcode) {
        String toolheadCmd = "M104.*";
        for (String line : gcode) {
            if (!line.matches(toolheadCmd)) continue;
            return line;
        }
        return "";
    }

    public static void preprocessForCombine(ArrayList<String> gcode) {
        DualStrusionWorker.stripEndlines(gcode);
        DualStrusionWorker.stripEmptyLayers(gcode);
    }

    public static File combineGcode(File primary, File secondary, File dest, boolean replaceStart, boolean replaceEnd, boolean useWipes) {
        ArrayList<String> primaryGcode = DualStrusionWorker.readFiletoArrayList(primary);
        ArrayList<String> secondaryGcode = DualStrusionWorker.readFiletoArrayList(secondary);
        ArrayList<Object> master_layer = new ArrayList();
        ArrayList<String> startGcode = DualStrusionWorker.readFiletoArrayList(new File("DualStrusion_Snippets/start.gcode"));
        ArrayList<String> endGcode = DualStrusionWorker.readFiletoArrayList(new File("DualStrusion_Snippets/end.gcode"));
        String primaryTemp = DualStrusionWorker.getTemperatureCommand(primaryGcode);
        String secondaryTemp = DualStrusionWorker.getTemperatureCommand(secondaryGcode);
        primaryTemp = DualStrusionWorker.swapToolhead(primaryTemp, Toolheads.PRIMARY.getTid());
        if (replaceStart) {
            DualStrusionWorker.stripStartGcode(primaryGcode);
        } else {
            startGcode = DualStrusionWorker.saveStartGcode(primaryGcode);
        }
        if (!replaceEnd) {
            endGcode = DualStrusionWorker.saveEndGcode(primaryGcode);
        }
        DualStrusionWorker.stripStartGcode(secondaryGcode);
        DualStrusionWorker.stripEndGcode(secondaryGcode);
        primaryGcode = DualStrusionWorker.replaceToolHeadReferences(primaryGcode, Toolheads.PRIMARY);
        secondaryGcode = DualStrusionWorker.replaceToolHeadReferences(secondaryGcode, Toolheads.SECONDARY);
        LayerHelper helper = new LayerHelper(primaryGcode, secondaryGcode, false, useWipes);
        master_layer = helper.mergeLayers();
        DualStrusionWorker.modifyTempReference(startGcode, Toolheads.PRIMARY, primaryTemp);
        DualStrusionWorker.modifyTempReference(startGcode, Toolheads.SECONDARY, secondaryTemp);
        master_layer.addAll(0, startGcode);
        master_layer.addAll(master_layer.size(), endGcode);
        DualStrusionWorker.mayHaveWipeCrash(master_layer);
        DualStrusionWorker.writeArrayListtoFile(master_layer, dest);
        return dest;
    }

    private static void modifyTempReference(ArrayList<String> gcode, Toolheads toolhead, String newTempCmd) {
        String matchTarget = "M104.*" + toolhead.getTid() + ".*";
        for (int i = 0; i < gcode.size(); ++i) {
            if (!gcode.get(i).matches(matchTarget)) continue;
            gcode.set(i, newTempCmd);
        }
    }

    public static void changeToolHead(File source, String Toolhead) {
        ArrayList<String> startGcode = DualStrusionWorker.readFiletoArrayList(new File("DualStrusion_Snippets/start.gcode"));
        ArrayList<String> endGcode = DualStrusionWorker.readFiletoArrayList(new File("DualStrusion_Snippets/end.gcode"));
        ArrayList<String> gcode = DualStrusionWorker.readFiletoArrayList(source);
        Toolheads t = Toolheads.SECONDARY;
        if (Toolhead.equalsIgnoreCase("right")) {
            t = Toolheads.SECONDARY;
        } else if (Toolhead.equalsIgnoreCase("left")) {
            t = Toolheads.PRIMARY;
        }
        DualStrusionWorker.stripStartGcode(gcode);
        DualStrusionWorker.stripEndGcode(gcode);
        gcode = DualStrusionWorker.replaceToolHeadReferences(gcode, t);
        gcode.addAll(0, startGcode);
        gcode.addAll(endGcode);
        DualStrusionWorker.changeOffsetRecall(gcode, t);
        DualStrusionWorker.writeArrayListtoFile(gcode, source);
    }

    public static void changeOffsetRecall(ArrayList<String> gcode, Toolheads toolhead) {
        for (int i = 0; i < gcode.size(); ++i) {
            if (!gcode.get(i).matches("G54.*")) continue;
            String comment = DualStrusionWorker.pullComment(gcode.get(i), true);
            gcode.set(i, toolhead.getRecallOffsetGcodeCommand() + comment);
        }
    }

    private static String swapToolhead(String command, String targetToolhead) {
        int lastT0 = command.lastIndexOf("T0");
        int lastT1 = command.lastIndexOf("T1");
        String comments = DualStrusionWorker.pullComment(command, true);
        if (lastT0 != -1) {
            command = command.substring(0, lastT0);
        } else if (lastT1 != -1) {
            command = command.substring(0, lastT1);
        } else if (lastT1 == -1 && lastT0 == -1 && !comments.equals("")) {
            command = command.substring(0, command.indexOf("("));
        }
        if (!command.endsWith(" ")) {
            command = command + " ";
        }
        command = command + targetToolhead + comments;
        return command;
    }

    private static ArrayList<String> replaceToolHeadReferences(ArrayList<String> gcode, Toolheads desiredToolhead) {
        ArrayList<String> newGcode = new ArrayList<String>();
        String newToolhead = desiredToolhead.getTid();
        for (String s : gcode) {
            if (s.matches("(M10[12345678]|M113).*")) {
                s = DualStrusionWorker.swapToolhead(s, newToolhead);
            }
            newGcode.add(s);
        }
        return newGcode;
    }

    private static ArrayList<String> saveStartGcode(ArrayList<String> gcode) {
        ArrayList<String> startGcode = new ArrayList<String>();
        int start = -1;
        int end2 = -1;
        for (int i = 0; i < gcode.size() - 1; ++i) {
            if (start == -1 && gcode.get(i).equalsIgnoreCase("(**** beginning of start.gcode ****)")) {
                start = i;
                Base.logger.finer("Saving start gcode");
                continue;
            }
            if (!gcode.get(i).equalsIgnoreCase("(**** end of start.gcode ****)")) continue;
            end2 = i;
            startGcode.addAll(gcode.subList(end2, start));
            gcode.subList(end2, start).clear();
        }
        return startGcode;
    }

    private static ArrayList<String> saveEndGcode(ArrayList<String> gcode) {
        ArrayList<String> endGcode = new ArrayList<String>();
        for (int i = gcode.size() / 4 * 3; i < gcode.size() - 1; ++i) {
            if (!gcode.get(i).equalsIgnoreCase("(**** Beginning of end.gcode ****)")) continue;
            Base.logger.finer("saving end gcode");
            int a = i;
            while (true) {
                if (!gcode.get(++a).equalsIgnoreCase("(**** end of end.gcode ****)")) {
                    continue;
                }
                endGcode.addAll(gcode.subList(i, a + 1));
            }
        }
        return endGcode;
    }

    private static void stripEndGcode(ArrayList<String> gcode) {
        for (int i = gcode.size() / 4 * 3; i < gcode.size() - 1; ++i) {
            if (!gcode.get(i).equalsIgnoreCase("(**** Beginning of end.gcode ****)")) continue;
            Base.logger.finer("Stripping end gcode");
            int a = i;
            while (!gcode.get(++a).equalsIgnoreCase("(**** end of end.gcode ****)")) {
            }
            gcode.subList(i, a + 1).clear();
            return;
        }
    }

    public static void stripStartGcode(ArrayList<String> gcode) {
        for (int i = 0; i < gcode.size() - 1; ++i) {
            if (!gcode.get(i).equalsIgnoreCase("(**** beginning of start.gcode ****)")) continue;
            int a = i;
            while (!gcode.get(++a).equalsIgnoreCase("(**** end of start.gcode ****)")) {
            }
            gcode.subList(i, a + 1).clear();
            return;
        }
    }

    public static boolean mayHaveWipeCrash(ArrayList<String> gcode) {
        for (String command : gcode) {
            if (!command.matches("G1 .*") || !DualStrusionWorker.outOfBoundsY(command, yDanger)) continue;
            Base.logger.warning("command may go beyond allowed Y distance");
            Base.logger.warning("Line: " + command);
            Base.logger.warning("Y boundary: " + yDanger);
            return true;
        }
        return false;
    }

    private static boolean outOfBoundsY(String suspectLine, double yBoundry) {
        if (suspectLine.matches("G1 .*")) {
            String[] chunks;
            for (String s : chunks = suspectLine.split(" ")) {
                float yVal;
                if (s.length() <= 1 || s.charAt(0) != 'Y' || !((double)(yVal = Float.parseFloat(s.substring(1, s.length()))) >= yBoundry)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static void stripSurroundingLoop(ArrayList<String> gcode) {
        for (int i = 0; i < gcode.size() - 2; ++i) {
            int a;
            if (gcode.get(i).equals("(<surroundingLoop>)")) {
                a = i;
                while (!gcode.get(++a).equals("(</surroundingLoop>)")) {
                }
                gcode.subList(i, ++a).clear();
                continue;
            }
            if (!gcode.get(i).equals("(<loop inner>)")) continue;
            a = i;
            while (!gcode.get(++a).equals("(</loop>)")) {
            }
            gcode.subList(i, ++a).clear();
        }
    }

    private static void stripEmptyLayers(ArrayList<String> gcode) {
        int max = gcode.size() - 2;
        for (int i = 0; i < gcode.size() - 2; ++i) {
            if (!gcode.get(i).matches("\\(\\<layer\\>.*\\)")) continue;
            boolean containsUsefulCode = false;
            int a = i + 1;
            while (true) {
                if (gcode.get(a).matches("\\(\\</layer\\>\\)")) {
                    ++a;
                    break;
                }
                if (!gcode.get(a).matches("\\(\\<.*\\>\\)")) {
                    containsUsefulCode = true;
                    break;
                }
                ++a;
            }
            if (containsUsefulCode) continue;
            gcode.subList(i, a).clear();
            i -= a - i;
        }
    }

    private static boolean checkVersion(ArrayList<String> gcode) {
        boolean compliantSkein = false;
        boolean compliantVer = false;
        String version = "10.11.05";
        for (String s : gcode) {
            if (s.matches("\\(\\<creation\\>.*\\<\\/creation\\>\\)") && s.contains("skeinforge")) {
                compliantSkein = true;
            }
            if (s.matches("\\(\\<version\\>.*\\<\\/version\\>\\)")) {
                System.out.println(s);
                if (s.contains(version)) {
                    compliantVer = true;
                }
            }
            if (!compliantSkein || !compliantVer) continue;
            return true;
        }
        return false;
    }

    public static void writeArrayListtoFile(ArrayList<String> t, File f) {
        try {
            FileWriter bwr = new FileWriter(f);
            for (String s : t) {
                bwr.write(s + "\n");
            }
            bwr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<String> readFiletoArrayList(File f) {
        ArrayList<String> vect = new ArrayList<String>();
        try {
            BufferedReader bir = new BufferedReader(new FileReader(f));
            String curline = bir.readLine();
            while (curline != null) {
                vect.add(curline);
                curline = bir.readLine();
            }
            bir.close();
        }
        catch (IOException e) {
            System.err.println("couldnt read file " + f.getAbsolutePath());
        }
        return vect;
    }
}

