/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.dualstrusion;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import replicatorg.dualstrusion.DualStrusionWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeCombination {
    public static File mergeGCodes(File dest, List<File> files) {
        ArrayList<String> output = new ArrayList<String>();
        ArrayList<String> tween = DualStrusionWorker.readFiletoArrayList(new File("DualStrusion_Snippets/rctween.gcode"));
        for (File f : files) {
            String l;
            int i;
            int end2;
            int start;
            ArrayList<String> lines = DualStrusionWorker.readFiletoArrayList(f);
            DualStrusionWorker.preprocessForCombine(lines);
            if (f != files.get(0)) {
                start = -1;
                end2 = -1;
                for (i = 0; i < lines.size(); ++i) {
                    l = lines.get(i);
                    if (l.equalsIgnoreCase("(**** beginning of start.gcode ****)")) {
                        start = i;
                    }
                    if (start != -1 && l.matches("M104.*")) {
                        output.add(l.substring(0));
                    }
                    if (!l.equalsIgnoreCase("(**** end of start.gcode ****)")) continue;
                    end2 = i;
                    break;
                }
                if (start != -1) {
                    lines.subList(start, end2 + 1).clear();
                }
                output.addAll(tween);
            }
            if (f != files.get(files.size() - 1)) {
                start = -1;
                end2 = -1;
                for (i = 0; i < lines.size(); ++i) {
                    l = lines.get(i);
                    if (l.equalsIgnoreCase("(**** beginning of end.gcode ****)")) {
                        start = i;
                    }
                    if (!l.equalsIgnoreCase("(**** end of end.gcode ****)")) continue;
                    end2 = i;
                    break;
                }
                if (start != -1) {
                    lines.subList(start, end2 + 1).clear();
                }
            }
            output.addAll(lines);
        }
        DualStrusionWorker.mayHaveWipeCrash(output);
        DualStrusionWorker.writeArrayListtoFile(output, dest);
        return dest;
    }
}

