/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.reprap;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.tools.XML;
import replicatorg.app.util.serial.ByteFifo;
import replicatorg.app.util.serial.SerialFifoEventListener;
import replicatorg.drivers.RealtimeControl;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.SerialDriver;
import replicatorg.drivers.reprap.ExtrusionUpdater;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.ToolModel;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepRap5DDriver
extends SerialDriver
implements SerialFifoEventListener,
RealtimeControl {
    private static Pattern gcodeCommentPattern = Pattern.compile("\\([^)]*\\)|;.*");
    private static Pattern resendLinePattern = Pattern.compile("([0-9]+)");
    private static Pattern gcodeLineNumberPattern = Pattern.compile("n\\s*([0-9]+)");
    public final AtomicReference<Double> feedrate = new AtomicReference<Double>(0.0);
    public final AtomicReference<Double> ePosition = new AtomicReference<Double>(0.0);
    private final ReentrantLock sendCommandLock = new ReentrantLock();
    private final AtomicBoolean startReceived = new AtomicBoolean(false);
    private final AtomicBoolean okReceived = new AtomicBoolean(false);
    private int debugLevel = 0;
    private int introduceNoiseEveryN = -1;
    private int lineIterator = 0;
    private int numResends = 0;
    private boolean fiveD = true;
    private boolean hasChecksums = true;
    private boolean pulseRTS = true;
    private boolean okAfterResend = true;
    private boolean okAfterStart = false;
    private boolean alwaysRelativeE = false;
    private boolean waitForStart = false;
    private long waitForStartTimeout = 1000L;
    private int waitForStartRetries = 3;
    private boolean realtimeControl = false;
    private double rcFeedrateMultiply = 1.0;
    private double rcTravelFeedrateMultiply = 1.0;
    private double rcExtrusionMultiply = 1.0;
    private double rcFeedrateLimit = 18000.0;
    private final ExtrusionUpdater extrusionUpdater = new ExtrusionUpdater(this);
    private int maxBufferSize = 128;
    private LinkedList<String> buffer = new LinkedList();
    private ReentrantLock bufferLock = new ReentrantLock();
    private ReentrantLock readResponseLock = new ReentrantLock();
    protected DecimalFormat df;
    private AtomicInteger lineNumber = new AtomicInteger(-1);

    public RepRap5DDriver() {
        this.hasEmergencyStop = false;
        this.hasSoftStop = false;
        this.setInitialized(false);
        DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
        dfs.setDecimalSeparator('.');
        this.df = new DecimalFormat("#.######", dfs);
    }

    @Override
    public String getDriverName() {
        return "RepRap5D";
    }

    @Override
    public synchronized void loadXML(Node xml) {
        double introduceNoise;
        super.loadXML(xml);
        if (XML.hasChildNode(xml, "waitforstart")) {
            String retries;
            String timeout;
            Node startNode = XML.getChildNodeByName(xml, "waitforstart");
            String enabled = XML.getAttributeValue(startNode, "enabled");
            if (enabled != null) {
                this.waitForStart = Boolean.parseBoolean(enabled);
            }
            if ((timeout = XML.getAttributeValue(startNode, "timeout")) != null) {
                this.waitForStartTimeout = Long.parseLong(timeout);
            }
            if ((retries = XML.getAttributeValue(startNode, "retries")) != null) {
                this.waitForStartRetries = Integer.parseInt(retries);
            }
        }
        if (XML.hasChildNode(xml, "pulserts")) {
            this.pulseRTS = Boolean.parseBoolean(XML.getChildNodeValue(xml, "pulserts"));
        }
        if (XML.hasChildNode(xml, "checksums")) {
            this.hasChecksums = Boolean.parseBoolean(XML.getChildNodeValue(xml, "checksums"));
        }
        if (XML.hasChildNode(xml, "fived")) {
            this.fiveD = Boolean.parseBoolean(XML.getChildNodeValue(xml, "fived"));
        }
        if (XML.hasChildNode(xml, "debugLevel")) {
            this.debugLevel = Integer.parseInt(XML.getChildNodeValue(xml, "debugLevel"));
        }
        if (XML.hasChildNode(xml, "limitFeedrate")) {
            this.rcFeedrateLimit = Double.parseDouble(XML.getChildNodeValue(xml, "limitFeedrate"));
        }
        if (XML.hasChildNode(xml, "okAfterResend")) {
            this.okAfterResend = Boolean.parseBoolean(XML.getChildNodeValue(xml, "okAfterResend"));
        }
        if (XML.hasChildNode(xml, "okAfterStart")) {
            this.okAfterStart = Boolean.parseBoolean(XML.getChildNodeValue(xml, "okAfterStart"));
        }
        if (XML.hasChildNode(xml, "alwaysRelativeE")) {
            this.alwaysRelativeE = Boolean.parseBoolean(XML.getChildNodeValue(xml, "alwaysRelativeE"));
        }
        if (XML.hasChildNode(xml, "hasEmergencyStop")) {
            this.hasEmergencyStop = Boolean.parseBoolean(XML.getChildNodeValue(xml, "hasEmergencyStop"));
        }
        if (XML.hasChildNode(xml, "hasSoftStop")) {
            this.hasSoftStop = Boolean.parseBoolean(XML.getChildNodeValue(xml, "hasSoftStop"));
        }
        if (XML.hasChildNode(xml, "introduceNoise") && (introduceNoise = Double.parseDouble(XML.getChildNodeValue(xml, "introduceNoise"))) != 0.0) {
            Base.logger.warning("Purposefully injecting noise into communications. This is NOT for production.");
            Base.logger.warning("Turn this off by removing introduceNoise from the machines XML file of your machine.");
            this.introduceNoiseEveryN = (int)(1.0 / introduceNoise);
        }
    }

    @Override
    public void updateManualControl() {
        try {
            this.extrusionUpdater.update();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendInitializationGcode(boolean synchronous) {
        this.sendCommand("M110", synchronous);
        this.sendCommand("G90", synchronous);
        this.sendCommand("G92 X0 Y0 Z0 E0", synchronous);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initialize() {
        if (this.serial == null) {
            Base.logger.severe("No Serial Port found.\n");
            return;
        }
        if (!this.isInitialized()) {
            Base.logger.info("Initializing Serial.");
            this.flushBuffer();
            if (this.pulseRTS) {
                Base.logger.fine("Resetting RepRap: Pulsing RTS..");
                int retriesRemaining = this.waitForStartRetries + 1;
                while (true) {
                    try {
                        this.pulseRTS();
                        Base.logger.finer("start received");
                    }
                    catch (TimeoutException e) {
                        if (--retriesRemaining == 0) {
                            this.disconnect();
                            Base.logger.warning("RepRap not responding to RTS reset. Failed to connect.");
                            return;
                        }
                        Base.logger.warning("RepRap not responding to RTS reset. Trying again..");
                        continue;
                    }
                    break;
                }
                Base.logger.fine("RepRap Reset. RTS pulsing complete.");
            }
            AtomicBoolean atomicBoolean = this.okReceived;
            synchronized (atomicBoolean) {
                this.okReceived.set(false);
                while (!this.okReceived.get()) {
                    this.sendCommand("M110", false);
                    Base.logger.info("GCode sent. waiting for response..");
                    try {
                        this.waitForNotification(this.okReceived, 10000L);
                    }
                    catch (RetryException e) {
                    }
                    catch (TimeoutException e) {
                        this.disconnect();
                        Base.logger.warning("Firmware not responding to gcode. Failed to connect.");
                        return;
                    }
                }
            }
            Base.logger.fine("GCode response received. RepRap connected.");
            this.sendInitializationGcode(true);
            Base.logger.info("Ready.");
            this.setInitialized(true);
        }
    }

    private void waitForNotification(AtomicBoolean notifier, long timeout) throws TimeoutException, RetryException {
        try {
            notifier.wait(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        if (notifier.get()) {
            return;
        }
        throw new RetryException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pulseRTS() throws TimeoutException {
        Base.logger.info("Attempting to reset RepRap (pulsing RTS)");
        AtomicBoolean atomicBoolean = this.startReceived;
        synchronized (atomicBoolean) {
            this.startReceived.set(false);
            this.serial.pulseRTSLow();
            if (!this.waitForStart) {
                return;
            }
            while (!this.startReceived.get()) {
                try {
                    this.waitForNotification(this.startReceived, this.waitForStartTimeout);
                }
                catch (RetryException e) {}
            }
        }
    }

    @Override
    public boolean isPassthroughDriver() {
        return true;
    }

    @Override
    public void executeGCodeLine(String code) {
        if (!this.isInitialized()) {
            return;
        }
        this.sendCommand(code);
    }

    private String getRegexMatch(String regex, String input, int group) {
        return this.getRegexMatch(Pattern.compile(regex), input, group);
    }

    private String getRegexMatch(Pattern regex, String input, int group) {
        Matcher matcher = regex.matcher(input);
        if (!matcher.find() || matcher.groupCount() < group) {
            return null;
        }
        return matcher.group(group);
    }

    protected void sendCommand(String next) {
        this._sendCommand(next, true, false);
    }

    protected void sendCommand(String next, boolean synchronous) {
        this._sendCommand(next, synchronous, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resendCommand(String command) {
        ReentrantLock reentrantLock = this.sendCommandLock;
        synchronized (reentrantLock) {
            ++this.numResends;
            if (this.debugLevel > 0) {
                Base.logger.warning("Resending: \"" + command + "\". Resends in " + this.numResends + " of " + this.lineIterator + " lines.");
            }
            this._sendCommand(command, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _sendCommand(String next, boolean synchronous, boolean resending) {
        String feedrate;
        if (!resending) {
            this.sendCommandLock.lock();
            next = this.clean(next);
            next = this.fix(next);
            if (next.length() == 0) {
                this.sendCommandLock.unlock();
                return;
            }
            feedrate = this.getRegexMatch("F(-[0-9\\.]+)", next, 1);
            if (feedrate != null) {
                this.feedrate.set(Double.parseDouble(feedrate));
            }
            if (!this.alwaysRelativeE) {
                String e = this.getRegexMatch("E([-0-9\\.]+)", next, 1);
                if (e != null) {
                    this.ePosition.set(Double.parseDouble(e));
                }
            } else {
                this.ePosition.set(0.0);
            }
            if (this.hasChecksums) {
                next = this.applyNandChecksum(next);
            }
            Base.logger.finest("sending: " + next);
        } else {
            Base.logger.finest("resending: " + next);
        }
        if (this.debugLevel > 1) {
            Base.logger.info("Sending: " + next);
        }
        try {
            feedrate = next;
            synchronized (feedrate) {
                this.serialInUse.lock();
                this.bufferLock.lock();
                this.buffer.addFirst(next);
                if (this.introduceNoiseEveryN != -1 && this.lineIterator++ >= this.introduceNoiseEveryN) {
                    Base.logger.info("Introducing noise (lineIterator==" + this.lineIterator + ",introduceNoiseEveryN=" + this.introduceNoiseEveryN + ")");
                    this.lineIterator = 0;
                    String noisyNext = next.replace('6', '7').replace('7', '1') + "\n";
                    this.serial.write(noisyNext);
                } else {
                    this.serial.write(next + "\n");
                }
                this.bufferLock.unlock();
                this.serialInUse.unlock();
                if (synchronous) {
                    next.wait();
                }
            }
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            if (!resending) {
                this.sendCommandLock.unlock();
            }
            return;
        }
        if (!resending) {
            this.sendCommandLock.unlock();
        }
    }

    public String clean(String str) {
        String clean = str;
        clean = clean.trim();
        clean = gcodeCommentPattern.matcher(clean).replaceAll("");
        return clean;
    }

    public String fix(String str) {
        String fixed = str;
        Pattern r = Pattern.compile("M01[^0-9]");
        Matcher m = r.matcher(fixed);
        if (m.find()) {
            return "";
        }
        r = Pattern.compile("M10[123](.*)");
        m = r.matcher(fixed);
        if (m.find()) {
            return "";
        }
        r = Pattern.compile("^(.*)(F[0-9\\.]*)\\s?E([0-9\\.]*)$");
        m = r.matcher(fixed);
        if (m.find()) {
            fixed = m.group(1) + " E" + m.group(3) + " " + m.group(2);
        }
        if (this.realtimeControl && (m = (r = Pattern.compile("(.*)F([0-9\\.]*)(.*)")).matcher(fixed)).find()) {
            double newvalue = Double.valueOf(m.group(2).trim());
            newvalue = !fixed.contains("E") ? (newvalue *= this.rcTravelFeedrateMultiply) : (newvalue *= this.rcFeedrateMultiply);
            if (newvalue > this.rcFeedrateLimit) {
                newvalue = this.rcFeedrateLimit;
            }
            DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
            dfs.setDecimalSeparator('.');
            DecimalFormat formatter = new DecimalFormat("#0.0", dfs);
            fixed = m.group(1) + " F" + formatter.format(newvalue) + " " + m.group(3);
        }
        return fixed;
    }

    public String applyNandChecksum(String gcode) {
        Matcher lineNumberMatcher;
        if (gcode.contains("M110")) {
            this.lineNumber.set(-1);
        }
        if ((lineNumberMatcher = gcodeLineNumberPattern.matcher(gcode)).matches()) {
            this.lineNumber.set(Integer.parseInt(lineNumberMatcher.group(1)));
        } else {
            gcode = "N" + this.lineNumber.incrementAndGet() + ' ' + gcode + ' ';
        }
        return this.applyChecksum(gcode);
    }

    public String applyChecksum(String gcode) {
        byte checksum = 0;
        byte[] gcodeBytes = gcode.getBytes();
        for (int i = 0; i < gcodeBytes.length; ++i) {
            checksum = (byte)(checksum ^ gcodeBytes[i]);
        }
        return gcode + '*' + checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialByteReceivedEvent(ByteFifo fifo) {
        this.readResponseLock.lock();
        this.serialInUse.lock();
        byte[] response = fifo.dequeueLine();
        int responseLength = response.length;
        this.serialInUse.unlock();
        if (responseLength < 0) {
            Base.logger.severe("SerialPassthroughDriver.readResponse(): EOF occured");
            this.readResponseLock.unlock();
            return;
        }
        if (responseLength != 0) {
            Object m;
            Serializable r;
            String line;
            try {
                line = new String(response, 0, responseLength, "US-ASCII").trim().toLowerCase();
            }
            catch (UnsupportedEncodingException e) {
                Base.logger.severe("US-ASCII required. Terminating.");
                this.readResponseLock.unlock();
                throw new RuntimeException(e);
            }
            if (this.debugLevel > 1) {
                Base.logger.info("<< " + line);
            }
            if (line.length() == 0) {
                Base.logger.fine("empty line received");
            } else if (line.startsWith("echo:")) {
                Base.logger.info(line);
            } else if (line.startsWith("ok t:") || line.startsWith("t:")) {
                r = Pattern.compile("t:([0-9\\.]+)");
                m = ((Pattern)r).matcher(line);
                if (((Matcher)m).find()) {
                    String temp = ((Matcher)m).group(1);
                    this.machine.currentTool().setCurrentTemperature(Double.parseDouble(temp));
                }
                if (((Matcher)(m = ((Pattern)(r = Pattern.compile("^ok.*b:([0-9\\.]+)$"))).matcher(line))).find()) {
                    String bedTemp = ((Matcher)m).group(1);
                    this.machine.currentTool().setPlatformCurrentTemperature(Double.parseDouble(bedTemp));
                }
            } else if ((line.startsWith("ok c:") || line.startsWith("c:")) && ((Matcher)(m = ((Pattern)(r = Pattern.compile("c: *x:?([-0-9\\.]+) *y:?([-0-9\\.]+) *z:?([-0-9\\.]+)"))).matcher(line))).find()) {
                double x = Double.parseDouble(((Matcher)m).group(1));
                double y = Double.parseDouble(((Matcher)m).group(2));
                double z = Double.parseDouble(((Matcher)m).group(3));
                try {
                    super.setCurrentPosition(new Point5d(x, y, z));
                }
                catch (RetryException e) {
                    // empty catch block
                }
            }
            if (line.startsWith("ok")) {
                Object notifier;
                r = this.okReceived;
                synchronized (r) {
                    this.okReceived.set(true);
                    this.okReceived.notifyAll();
                }
                this.bufferLock.lock();
                if (this.buffer.isEmpty()) {
                    Base.logger.severe("Received OK with nothing queued!");
                } else {
                    notifier = this.buffer.removeLast();
                    if (this.debugLevel > 1) {
                        Base.logger.info("FW Accepted: " + (String)notifier);
                    }
                    m = notifier;
                    synchronized (m) {
                        notifier.notifyAll();
                    }
                }
                this.bufferLock.unlock();
                notifier = this.bufferLock;
                synchronized (notifier) {
                    this.bufferLock.notifyAll();
                }
            }
            if (line.contains("start")) {
                this.lineNumber.set(-1);
                boolean active = !this.buffer.isEmpty();
                this.flushBuffer();
                if (this.isInitialized()) {
                    this.sendInitializationGcode(false);
                    if (active) {
                        Base.logger.severe("Firmware reset with active commands!");
                        this.setError("Firmware reset with active commands!");
                    }
                }
                if (this.okAfterStart) {
                    this.bufferLock.lock();
                    this.buffer.addLast(";start-ok");
                    this.bufferLock.unlock();
                }
                m = this.startReceived;
                synchronized (m) {
                    this.startReceived.set(true);
                    this.startReceived.notifyAll();
                }
                m = this.okReceived;
                synchronized (m) {
                    this.okReceived.set(false);
                    this.okReceived.notifyAll();
                }
            }
            if (line.startsWith("extruder fail")) {
                this.setError("Extruder failed:  cannot extrude as this rate.");
            } else if (line.startsWith("resend:") || line.startsWith("rs ")) {
                Matcher badLineMatch = resendLinePattern.matcher(line);
                String dudLetter = this.getRegexMatch("dud ([a-z]) code", line, 1);
                if (badLineMatch.find()) {
                    String bufferedLine;
                    int badLineNumber = Integer.parseInt(badLineMatch.group(1));
                    if (this.debugLevel > 1) {
                        Base.logger.warning("Received resend request for line " + badLineNumber);
                    }
                    LinkedList<String> resend = new LinkedList<String>();
                    boolean found = false;
                    this.bufferLock.lock();
                    while (!this.buffer.isEmpty()) {
                        bufferedLine = this.buffer.removeLast();
                        if (this.debugLevel > 1) {
                            Base.logger.info("Searching: " + bufferedLine);
                        }
                        int bufferedLineNumber = Integer.parseInt(this.getRegexMatch(gcodeLineNumberPattern, bufferedLine.toLowerCase(), 1));
                        if (dudLetter != null && bufferedLineNumber == badLineNumber) {
                            Base.logger.info("Dud " + dudLetter + " code: Dropping " + bufferedLine);
                            String string = bufferedLine;
                            synchronized (string) {
                                bufferedLine.notifyAll();
                            }
                            found = true;
                            break;
                        }
                        resend.add(bufferedLine);
                        if (bufferedLineNumber != badLineNumber) continue;
                        found = true;
                        break;
                    }
                    if (this.okAfterResend) {
                        this.buffer.addLast(";resend-ok");
                    }
                    this.bufferLock.unlock();
                    if (!found) {
                        int restartLineNumber = Integer.parseInt(this.getRegexMatch(gcodeLineNumberPattern, ((String)resend.element()).toLowerCase(), 1));
                        Base.logger.severe("resend for line " + badLineNumber + " not in our buffer.  Resuming from " + restartLineNumber);
                        this.resendCommand(this.applyChecksum("N" + (restartLineNumber - 1) + " M110"));
                    }
                    while (!resend.isEmpty()) {
                        bufferedLine = (String)resend.remove();
                        this.resendCommand(bufferedLine);
                    }
                } else {
                    Base.logger.warning("malformed line resend request, resetting line number. Malformed Data: \n" + line);
                    this.resendCommand(this.applyChecksum("N" + (this.lineNumber.get() - 1) + " M110"));
                }
            } else if (!line.startsWith("t:") && !line.startsWith("c:")) {
                Base.logger.severe("Unknown: " + line);
            }
        }
        this.readResponseLock.unlock();
    }

    @Override
    public boolean isFinished() {
        return this.isBufferEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() {
        this.bufferLock.lock();
        while (!this.buffer.isEmpty()) {
            String notifier = this.buffer.removeLast();
            if (this.debugLevel > 1) {
                Base.logger.fine("Flushing dead command: " + notifier);
            }
            String string = notifier;
            synchronized (string) {
                notifier.notifyAll();
            }
        }
        this.bufferLock.unlock();
    }

    @Override
    public boolean isBufferEmpty() {
        this.bufferLock.lock();
        boolean isEmpty = this.buffer.isEmpty();
        this.bufferLock.unlock();
        return isEmpty;
    }

    public int queueSize() {
        this.bufferLock.lock();
        int queueSize = this.buffer.size();
        this.bufferLock.unlock();
        return queueSize;
    }

    private synchronized void disconnect() {
        this.bufferLock.lock();
        this.flushBuffer();
        this.closeSerial();
        this.bufferLock.unlock();
    }

    @Override
    public synchronized void dispose() {
        this.bufferLock.lock();
        this.flushBuffer();
        super.dispose();
        this.bufferLock.unlock();
    }

    @Override
    public void queuePoint(Point5d p) throws RetryException {
        String cmd = "G1 F" + this.df.format(this.getCurrentFeedrate());
        this.sendCommand(cmd);
        cmd = "G1 X" + this.df.format(p.x()) + " Y" + this.df.format(p.y()) + " Z" + this.df.format(p.z()) + " F" + this.df.format(this.getCurrentFeedrate());
        this.sendCommand(cmd);
        super.queuePoint(p);
    }

    @Override
    public void setCurrentPosition(Point5d p) throws RetryException {
        this.sendCommand("G92 X" + this.df.format(p.x()) + " Y" + this.df.format(p.y()) + " Z" + this.df.format(p.z()));
        super.setCurrentPosition(p);
    }

    @Override
    public void homeAxes(EnumSet<AxisId> axes, boolean positive, double feedrate) throws RetryException {
        Base.logger.info("homing " + axes.toString());
        StringBuffer buf = new StringBuffer("G28");
        for (AxisId axis : axes) {
            buf.append(" " + (Object)((Object)axis) + "0");
        }
        this.sendCommand(buf.toString());
        this.invalidatePosition();
        super.homeAxes(axes, false, 0.0);
    }

    @Override
    public void delay(long millis) {
        int seconds = Math.round(millis / 1000L);
        this.sendCommand("G4 P" + seconds);
    }

    @Override
    public void openClamp(int clampIndex) {
        this.sendCommand("M11 Q" + clampIndex);
        super.openClamp(clampIndex);
    }

    @Override
    public void closeClamp(int clampIndex) {
        this.sendCommand("M10 Q" + clampIndex);
        super.closeClamp(clampIndex);
    }

    @Override
    public void enableDrives() throws RetryException {
        this.sendCommand("M17");
        super.enableDrives();
    }

    @Override
    public void disableDrives() throws RetryException {
        this.sendCommand("M18");
        this.sendCommand("M84");
        super.disableDrives();
    }

    @Override
    public void changeGearRatio(int ratioIndex) {
        int code = 40 + ratioIndex;
        code = Math.max(40, code);
        code = Math.min(46, code);
        this.sendCommand("M" + code);
        super.changeGearRatio(ratioIndex);
    }

    protected String _getToolCode() {
        return "T" + this.machine.currentTool().getIndex() + " ";
    }

    @Override
    public void setMotorRPM(double rpm) throws RetryException {
        if (!this.fiveD) {
            this.sendCommand(this._getToolCode() + "M108 R" + this.df.format(rpm));
        } else {
            this.extrusionUpdater.setFeedrate(rpm);
        }
        super.setMotorRPM(rpm);
    }

    @Override
    public void setMotorSpeedPWM(int pwm) throws RetryException {
        if (!this.fiveD) {
            this.sendCommand(this._getToolCode() + "M108 S" + this.df.format(pwm));
        }
        super.setMotorSpeedPWM(pwm);
    }

    @Override
    public synchronized void enableMotor() throws RetryException {
        String command = this._getToolCode();
        if (!this.fiveD) {
            command = this.machine.currentTool().getMotorDirection() == ToolModel.MOTOR_CLOCKWISE ? command + "M101" : command + "M102";
            this.sendCommand(command);
        } else {
            this.extrusionUpdater.setDirection(this.machine.currentTool().getMotorDirection() == 1 ? ExtrusionUpdater.Direction.forward : ExtrusionUpdater.Direction.reverse);
            this.extrusionUpdater.startExtruding();
        }
        super.enableMotor();
    }

    @Override
    public synchronized void enableMotor(long millis) throws RetryException {
        if (!this.fiveD) {
            super.enableMotor(millis);
        } else {
            super.enableMotor();
            double feedrate = this.machine.currentTool().getMotorSpeedRPM();
            double distance = (double)millis * feedrate / 60.0 / 1000.0;
            if (this.machine.currentTool().getMotorDirection() != 1) {
                distance *= -1.0;
            }
            this.sendCommand(this._getToolCode() + "G1 E" + (this.ePosition.get() + distance) + " F" + feedrate);
            super.disableMotor();
        }
    }

    @Override
    public void disableMotor() throws RetryException {
        if (!this.fiveD) {
            this.sendCommand(this._getToolCode() + "M103");
        } else {
            this.extrusionUpdater.stopExtruding();
        }
        super.disableMotor();
    }

    @Override
    public void setSpindleRPM(double rpm) throws RetryException {
        this.sendCommand(this._getToolCode() + "S" + this.df.format(rpm));
        super.setSpindleRPM(rpm);
    }

    @Override
    public void enableSpindle() throws RetryException {
        String command = this._getToolCode();
        command = this.machine.currentTool().getSpindleDirection() == ToolModel.MOTOR_CLOCKWISE ? command + "M3" : command + "M4";
        this.sendCommand(command);
        super.enableSpindle();
    }

    @Override
    public void disableSpindle() throws RetryException {
        this.sendCommand(this._getToolCode() + "M5");
        super.disableSpindle();
    }

    @Override
    public void setTemperature(double temperature) throws RetryException {
        this.sendCommand(this._getToolCode() + "M104 S" + this.df.format(temperature));
        super.setTemperature(temperature);
    }

    @Override
    public void readTemperature() {
        this.sendCommand(this._getToolCode() + "M105");
        super.readTemperature();
    }

    @Override
    public double getPlatformTemperature() {
        return this.machine.currentTool().getPlatformCurrentTemperature();
    }

    @Override
    public void setPlatformTemperature(double temperature) throws RetryException {
        this.sendCommand(this._getToolCode() + "M140 S" + this.df.format(temperature));
        super.setPlatformTemperature(temperature);
    }

    @Override
    public void enableFloodCoolant() {
        this.sendCommand(this._getToolCode() + "M7");
        super.enableFloodCoolant();
    }

    @Override
    public void disableFloodCoolant() {
        this.sendCommand(this._getToolCode() + "M9");
        super.disableFloodCoolant();
    }

    @Override
    public void enableMistCoolant() {
        this.sendCommand(this._getToolCode() + "M8");
        super.enableMistCoolant();
    }

    @Override
    public void disableMistCoolant() {
        this.sendCommand(this._getToolCode() + "M9");
        super.disableMistCoolant();
    }

    @Override
    public void enableFan() throws RetryException {
        this.sendCommand(this._getToolCode() + "M106");
        super.enableFan();
    }

    @Override
    public void disableFan() throws RetryException {
        this.sendCommand(this._getToolCode() + "M107");
        super.disableFan();
    }

    @Override
    public void openValve() throws RetryException {
        this.sendCommand(this._getToolCode() + "M126");
        super.openValve();
    }

    @Override
    public void closeValve() throws RetryException {
        this.sendCommand(this._getToolCode() + "M127");
        super.closeValve();
    }

    @Override
    public void openCollet() {
        this.sendCommand(this._getToolCode() + "M21");
        super.openCollet();
    }

    @Override
    public void closeCollet() {
        this.sendCommand(this._getToolCode() + "M22");
        super.closeCollet();
    }

    @Override
    public void reset() {
        Base.logger.info("Reset.");
        this.setInitialized(false);
        this.initialize();
    }

    @Override
    public void stop(boolean abort) {
        this.invalidatePosition();
        Base.logger.info("RepRap/Ultimaker Machine stop called.");
    }

    @Override
    protected Point5d reconcilePosition() {
        this.sendCommand("M114");
        return null;
    }

    @Override
    public boolean hasFeatureRealtimeControl() {
        Base.logger.info("Yes, I have a Realtime Control feature.");
        return true;
    }

    @Override
    public void enableRealtimeControl(boolean enable) {
        this.realtimeControl = enable;
        Base.logger.info("Realtime Control (RC) is: " + this.realtimeControl);
    }

    @Override
    public double getExtrusionMultiplier() {
        return this.rcExtrusionMultiply;
    }

    @Override
    public double getFeedrateMultiplier() {
        return this.rcFeedrateMultiply;
    }

    @Override
    public double getTravelFeedrateMultiplier() {
        return this.rcTravelFeedrateMultiply;
    }

    @Override
    public boolean setExtrusionMultiplier(double multiplier) {
        this.rcExtrusionMultiply = multiplier;
        if (this.debugLevel == 2) {
            Base.logger.info("RC muplipliers: extrusion=" + this.rcExtrusionMultiply + "x, feedrate=" + this.rcFeedrateMultiply + "x");
        }
        return true;
    }

    @Override
    public boolean setFeedrateMultiplier(double multiplier) {
        this.rcFeedrateMultiply = multiplier;
        if (this.debugLevel == 2) {
            Base.logger.info("RC muplipliers: extrusion=" + this.rcExtrusionMultiply + "x, feedrate=" + this.rcFeedrateMultiply + "x");
        }
        return true;
    }

    @Override
    public boolean setTravelFeedrateMultiplier(double multiplier) {
        this.rcTravelFeedrateMultiply = multiplier;
        if (this.debugLevel == 2) {
            Base.logger.info("RC muplipliers: extrusion=" + this.rcExtrusionMultiply + "x, feedrate=" + this.rcFeedrateMultiply + "x, travel feedrate=" + this.rcTravelFeedrateMultiply + "x");
        }
        return true;
    }

    @Override
    public void setDebugLevel(int level) {
        this.debugLevel = level;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public double getFeedrateLimit() {
        return this.rcFeedrateLimit;
    }

    @Override
    public boolean setFeedrateLimit(double limit) {
        this.rcFeedrateLimit = limit;
        return true;
    }
}

