/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.gen3;

import java.util.logging.Level;
import replicatorg.app.Base;
import replicatorg.app.tools.IButtonCrc;
import replicatorg.drivers.gen3.PacketConstants;
import replicatorg.drivers.gen3.PacketResponse;

public class PacketProcessor
implements PacketConstants {
    PacketState packetState = PacketState.START;
    int payloadLength = -1;
    int payloadIdx = 0;
    byte[] payload;
    byte targetCrc = 0;
    IButtonCrc crc;

    public void reset() {
        this.packetState = PacketState.START;
    }

    public PacketResponse getResponse() {
        PacketResponse pr = new PacketResponse(this.payload);
        return pr;
    }

    public boolean processByte(byte b) throws CRCException {
        if (Base.logger.isLoggable(Level.FINER)) {
            if (b >= 32 && b <= 127) {
                Base.logger.log(Level.FINER, "IN: Processing byte " + Integer.toHexString(b & 0xFF) + " (" + (char)b + ")");
            } else {
                Base.logger.log(Level.FINER, "IN: Processing byte " + Integer.toHexString(b & 0xFF));
            }
        }
        switch (this.packetState) {
            case START: {
                if (b != -43) break;
                this.packetState = PacketState.LEN;
                break;
            }
            case LEN: {
                if (Base.logger.isLoggable(Level.FINER)) {
                    Base.logger.log(Level.FINER, "Length: " + b);
                }
                this.payloadLength = b & 0xFF;
                this.payload = new byte[this.payloadLength];
                this.crc = new IButtonCrc();
                this.packetState = this.payloadLength > 0 ? PacketState.PAYLOAD : PacketState.CRC;
                break;
            }
            case PAYLOAD: {
                if (this.payloadIdx < this.payloadLength) {
                    this.payload[this.payloadIdx++] = b;
                    this.crc.update(b);
                }
                if (this.payloadIdx < this.payloadLength) break;
                this.packetState = PacketState.CRC;
                break;
            }
            case CRC: {
                this.targetCrc = b;
                if (Base.logger.isLoggable(Level.FINER)) {
                    Base.logger.log(Level.FINER, "Target CRC: " + Integer.toHexString(this.targetCrc & 0xFF) + " - expected CRC: " + Integer.toHexString(this.crc.getCrc() & 0xFF));
                }
                if (this.crc.getCrc() != this.targetCrc) {
                    throw new CRCException(this.crc.getCrc(), this.targetCrc);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PacketState {
        START,
        LEN,
        PAYLOAD,
        CRC,
        LAST;

    }

    public static class CRCException
    extends Exception {
        private int expected;
        private int actual;

        public CRCException(int expected, int actual) {
            this.expected = expected;
            this.actual = actual;
        }

        public int getActual() {
            return this.actual;
        }

        public int getExpected() {
            return this.expected;
        }
    }
}

