/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.gen3;

import java.util.EnumMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import org.w3c.dom.Element;
import replicatorg.app.Base;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.gen3.MotherboardCommandCode;
import replicatorg.drivers.gen3.PacketBuilder;
import replicatorg.drivers.gen3.PacketResponse;
import replicatorg.drivers.gen3.Sanguino3GDriver;
import replicatorg.drivers.gen3.ToolCommandCode;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.MachineModel;
import replicatorg.machine.model.ToolModel;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Makerbot4GDriver
extends Sanguino3GDriver {
    private boolean stepperExtruderFanEnabled = false;
    EnumMap<AxisId, ToolModel> stepExtruderMap = new EnumMap(AxisId.class);

    @Override
    public String getDriverName() {
        return "Makerbot4G";
    }

    @Override
    public void reset() {
        this.stepperExtruderFanEnabled = false;
        super.reset();
    }

    @Override
    public void stop(boolean abort) {
        this.machine.currentTool().disableMotor();
        this.stepperExtruderFanEnabled = false;
        super.stop(abort);
    }

    private Iterable<AxisId> getHijackedAxes() {
        Vector<AxisId> axes = new Vector<AxisId>();
        for (Map.Entry<AxisId, ToolModel> entry : this.stepExtruderMap.entrySet()) {
            ToolModel curTool = this.machine.currentTool();
            AxisId axis = entry.getKey();
            if (!curTool.equals(entry.getValue())) continue;
            axes.add(axis);
        }
        return axes;
    }

    private Iterable<AxisId> getAllHijackedAxes() {
        Vector<AxisId> axes = new Vector<AxisId>();
        for (Map.Entry<AxisId, ToolModel> entry : this.stepExtruderMap.entrySet()) {
            AxisId axis = entry.getKey();
            axes.add(axis);
        }
        return axes;
    }

    @Override
    protected void queueAbsolutePoint(Point5d steps, long micros) throws RetryException {
        for (AxisId axis : this.getHijackedAxes()) {
            if (steps.axis(axis) == 0.0) continue;
            this.enableStepperExtruderFan(true);
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.QUEUE_POINT_EXT.getCode());
        if (Base.logger.isLoggable(Level.FINE)) {
            Base.logger.log(Level.FINE, "Queued absolute point " + steps + " at " + Long.toString(micros) + " usec.");
        }
        pb.add32((int)steps.x());
        pb.add32((int)steps.y());
        pb.add32((int)steps.z());
        pb.add32((int)steps.a());
        pb.add32((int)steps.b());
        pb.add32((int)micros);
        this.runCommand(pb.getPacket());
    }

    @Override
    public void setCurrentPosition(Point5d p) throws RetryException {
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.SET_POSITION_EXT.getCode());
        Point5d steps = this.machine.mmToSteps(p);
        pb.add32((long)steps.x());
        pb.add32((long)steps.y());
        pb.add32((long)steps.z());
        pb.add32((long)steps.a());
        pb.add32((long)steps.b());
        Base.logger.log(Level.FINE, "Set current position to " + p + " (" + steps + ")");
        this.runCommand(pb.getPacket());
        this.currentPosition.set(p);
    }

    @Override
    protected Point5d reconcilePosition() {
        Point5d steps;
        if (this.fileCaptureOstream != null) {
            return null;
        }
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.GET_POSITION_EXT.getCode());
        PacketResponse pr = this.runQuery(pb.getPacket());
        try {
            steps = new Point5d(pr.get32(), pr.get32(), pr.get32(), pr.get32(), pr.get32());
        }
        catch (NullPointerException npe) {
            Base.logger.log(Level.FINEST, "Invalid response packet");
            return null;
        }
        return this.machine.stepsToMM(steps);
    }

    @Override
    public void enableMotor() throws RetryException {
        this.machine.currentTool().enableMotor();
    }

    @Override
    public void disableMotor() throws RetryException {
        this.machine.currentTool().disableMotor();
    }

    @Override
    public void setMotorSpeedPWM(int pwm) throws RetryException {
        this.machine.currentTool().setMotorSpeedPWM(pwm);
    }

    @Override
    public void setMotorRPM(double rpm) throws RetryException {
        this.machine.currentTool().setMotorSpeedRPM(rpm);
    }

    @Override
    public void enableDrives() throws RetryException {
        this.enableStepperExtruderFan(true);
        super.enableDrives();
    }

    @Override
    public void disableDrives() throws RetryException {
        this.enableStepperExtruderFan(false);
        super.disableDrives();
    }

    public void enableStepperExtruderFan(boolean enabled) throws RetryException {
        if (this.stepperExtruderFanEnabled == enabled) {
            return;
        }
        byte flags = (byte)(enabled ? 1 : 0);
        flags = (byte)(flags | 2);
        Base.logger.log(Level.FINE, "Stepper Extruder fan w/flags: " + Integer.toBinaryString(flags));
        PacketBuilder pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.TOGGLE_MOTOR_1.getCode());
        pb.add8(1);
        pb.add8(flags);
        this.runCommand(pb.getPacket());
        pb = new PacketBuilder(MotherboardCommandCode.TOOL_COMMAND.getCode());
        pb.add8((byte)this.machine.currentTool().getIndex());
        pb.add8(ToolCommandCode.SET_MOTOR_1_PWM.getCode());
        pb.add8(1);
        pb.add8(-1);
        this.runCommand(pb.getPacket());
        this.stepperExtruderFanEnabled = enabled;
    }

    @Override
    public void setMachine(MachineModel m) {
        super.setMachine(m);
        for (ToolModel tm : m.getTools()) {
            Element e = (Element)tm.getXml();
            if (!e.hasAttribute("stepper_axis")) continue;
            String stepAxisStr = e.getAttribute("stepper_axis");
            try {
                AxisId axis = AxisId.valueOf(stepAxisStr.toUpperCase());
                if (m.hasAxis(axis)) {
                    this.stepExtruderMap.put(axis, tm);
                    continue;
                }
                Base.logger.severe("Tool claims unavailable axis " + axis.name());
            }
            catch (IllegalArgumentException iae) {
                Base.logger.severe("Unintelligible axis designator " + stepAxisStr);
            }
        }
    }
}

